package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class BatchReverseRequest implements Serializable {
    /**
     * 需要红冲的蓝票集合
     */
    private List<ReverseData> reverseInvoiceList;
    private String reverseTerminalUn;
    private String reverseDeviceUn;
    private String reverseTerminalType;
    private Integer reverseDeployType;
    private String reverseIssuer;
    private Long taskId;
    private String requestSource;
    /**
     * 1释放预制发票 2释放业务单  3不释放预制发票或业务单 4 释放业务单 但是 不释放 明细
     */
    @ApiModelProperty("释放类型")
    private Integer releaseType;
    @ApiModelProperty("红票的国税发票来源，发票里有数电红冲税控时必填")
    private String redTaxInvoiceSource;

    @ApiModelProperty("默认不传-仅批量红冲 red_issue_print-红冲并打印 ")
    private String mode = null;

    private String nextInvoiceNo;

    private String nextInvoiceCode;

    private Boolean qdPassOperator;
    
    @ApiModelProperty(value = "是否乐企标识")
    private Boolean isNaturalSystemFlag;
    @ApiModelProperty(value = "自动申请红字确认单")
    private Integer autoApply;
}
