package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 单据信息
 */
@ApiModel(description = "单据信息")

@JsonInclude(NON_NULL)
@Data
public class BillInfo {
  @JsonProperty("salesbillId")
  private String salesbillId = null;

  @JsonProperty("importBatchNo")
  private String importBatchNo = null;

  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("sellerTenantId")
  private Long sellerTenantId = null;

  @JsonProperty("sellerGroupId")
  private Long sellerGroupId;

  @JsonProperty("sellerId")
  private Long sellerId;

  @JsonProperty("sellerNo")
  private String sellerNo = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerTel")
  private String sellerTel = null;

  @JsonProperty("sellerAddress")
  private String sellerAddress = null;

  @JsonProperty("sellerBankName")
  private String sellerBankName = null;

  @JsonProperty("sellerBankAccount")
  private String sellerBankAccount = null;

  /**
   * 销方证件类型
   */
  private String sellerIdentityType;

  /**
   * 销方自然人标识
   */
  private Integer sellerType;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaserTenantId")
  private Long purchaserTenantId = null;

  @JsonProperty("purchaserCode")
  private String purchaserCode = null;

  @JsonProperty("purchaserNo")
  private String purchaserNo = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserTel")
  private String purchaserTel = null;

  @JsonProperty("purchaserAddress")
  private String purchaserAddress = null;

  @JsonProperty("purchaserBankName")
  private String purchaserBankName = null;

  @JsonProperty("purchaserBankAccount")
  private String purchaserBankAccount = null;

  @JsonProperty("purchaserId")
  private Long purchaserId = null;

  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId;

  @Getter
  @Setter
  @JsonProperty("purchaserType")
  private Integer purchaserType;

  @JsonProperty("systemOrig")
  private String systemOrig = null;

  @JsonProperty("sysOrgId")
  private Long sysOrgId;

  @JsonProperty("sysOrgCode")
  private String sysOrgCode;

  @JsonProperty("sysOrgName")
  private String sysOrgName;

  @JsonProperty("businessBillType")
  private String businessBillType = null;

  @JsonProperty("salesbillType")
  private String salesbillType = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("priceMethod")
  private String priceMethod = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("alreadyMakeAmountWithTax")
  private BigDecimal alreadyMakeAmountWithTax;

  @JsonProperty("alreadyMakeAmountWithoutTax")
  private BigDecimal alreadyMakeAmountWithoutTax;

  @JsonProperty("alreadyMakeAmountTaxAmount")
  private BigDecimal alreadyMakeAmountTaxAmount;

  @JsonProperty("discountWithTax")
  private String discountWithTax = null;

  @JsonProperty("discountWithoutTax")
  private String discountWithoutTax = null;

  @JsonProperty("discountTax")
  private String discountTax = null;

  @JsonProperty("prePayWithoutTax")
  private String prePayWithoutTax = null;

  @JsonProperty("prePayTax")
  private String prePayTax = null;

  @JsonProperty("prePayWithTax")
  private String prePayWithTax = null;

  @JsonProperty("outterDiscountWithTax")
  private BigDecimal outterDiscountWithTax = null;
  @JsonProperty("outterDiscountWithoutTax")
  private BigDecimal outterDiscountWithoutTax = null;
  @JsonProperty("outterDiscountTax")
  private BigDecimal outterDiscountTax = null;
  @JsonProperty("innerDiscountWithTax")
  private BigDecimal innerDiscountWithTax = null;
  @JsonProperty("innerDiscountWithoutTax")
  private BigDecimal innerDiscountWithoutTax = null;
  @JsonProperty("innerDiscountTax")
  private BigDecimal innerDiscountTax = null;

  @JsonProperty("originInvoiceNo")
  private String originInvoiceNo = null;

  @JsonProperty("originInvoiceCode")
  private String originInvoiceCode = null;

  @JsonProperty("originInvoiceType")
  private String originInvoiceType ;

  @JsonProperty("originPaperDrawDate")
  private String originPaperDrawDate ;

  @JsonProperty("redNotification")
  private String redNotification = null;

  @JsonProperty("checkerName")
  private String checkerName = null;

  @JsonProperty("cashierName")
  private String cashierName = null;

  @JsonProperty("invoicerName")
  private String invoicerName = null;

  @JsonProperty("receiveUserEmail")
  private String receiveUserEmail = null;

  @JsonProperty("receiveUserTel")
  private String receiveUserTel = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("modifyMark")
  private Integer  modifyMark = null;

  @JsonProperty("customerNo")
  private String customerNo;

  @JsonProperty("remark")
  private String remark;

  @JsonProperty("redNotificationNo")
  private String redNotificationNo;

  @JsonProperty("ext1")
  private String ext1 = null;

  @JsonProperty("ext2")
  private String ext2 = null;

  @JsonProperty("ext3")
  private String ext3 = null;

  @JsonProperty("ext4")
  private String ext4 = null;

  @JsonProperty("ext5")
  private String ext5 = null;

  @JsonProperty("ext6")
  private String ext6 = null;

  @JsonProperty("ext7")
  private String ext7 = null;

  @JsonProperty("ext8")
  private String ext8 = null;

  @JsonProperty("ext9")
  private String ext9 = null;

  @JsonProperty("ext10")
  private String ext10 = null;

  @JsonProperty("ext11")
  private String ext11 = null;

  @JsonProperty("ext12")
  private String ext12 = null;

  @JsonProperty("ext13")
  private String ext13 = null;

  @JsonProperty("ext14")
  private String ext14 = null;

  @JsonProperty("ext15")
  private String ext15 = null;

  @JsonProperty("ext16")
  private String ext16 = null;

  @JsonProperty("ext17")
  private String ext17 = null;

  @JsonProperty("ext18")
  private String ext18 = null;

  @JsonProperty("ext19")
  private String ext19 = null;

  @JsonProperty("ext20")
  private String ext20 = null;

  @JsonProperty("ext21")
  private String ext21 = null;

  @JsonProperty("ext22")
  private String ext22 = null;

  @JsonProperty("ext23")
  private String ext23 = null;

  @JsonProperty("ext24")
  private String ext24 = null;

  @JsonProperty("ext25")
  private String ext25 = null;

  @JsonProperty("extInfo")
  private String extInfo = null;

  @JsonProperty("taxInvoiceSource")
  private String taxInvoiceSource = null;


  @JsonProperty("originalSalesbillNo")
  private String originalSalesbillNo = null;


  @ApiModelProperty("系统来源类型")
  @JsonProperty("systemOrigType")
  private Integer systemOrigType;

  @ApiModelProperty("渠道")
  @JsonProperty("channel")
  private Long channel;

  @ApiModelProperty("业务单代数")
  @JsonProperty("generation")
  private Long generation;

  @JsonProperty("billItems")
  private List<BillItem> billItems = new ArrayList<>();

  /**
   * 业务单预申请红字确认单会传值
   */
  @ApiModelProperty("拆票明细的关联关系（仅在不调用拆票服务时起作用）")
  private List<SplitItemRelationVo> itemRelationList = Lists.newArrayList();

  @ApiModelProperty("自定义属性")
  private BillCustomAttr customAttr;

  /**
   * 开票方编号
   */
  private String issuerNo;

  /**
   * 开票方名称
   */
  private String issuerName;

  /**
   * 开票方税号
   */
  private String issuerTaxNo;

  /**
   * 开票方电话
   */
  private String issuerTel;

  /**
   * 开票方地址
   */
  private String issuerAddress;

  /**
   * 开票方银行名称
   */
  private String issuerBankName;

  /**
   * 开票方银行账号
   */
  private String issuerBankAccount;

  /**
   * 开票方集团id
   */
  private Long issuerGroupId;

  /**
   * 开票方公司id
   */
  private Long issuerId;

  /**
   * 仅支持es查询的属性
   */
  private BillOnlyEsQueryAttr onlyEsQueryAttr;
  /**
   * 模式类型
   */
  private Integer modelFlag;

}
