package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票所属单据请求对象
 */
@ApiModel(description = "预制发票所属单据请求对象")

@JsonInclude(NON_NULL)
public class BillOfPreInvoiceRequest {
  @JsonProperty("preInvoiceId")
  private Long preInvoiceId = null;

  @JsonProperty("salesbillId")
  private Long salesbillId = null;

  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonIgnore
  public BillOfPreInvoiceRequest preInvoiceId(Long preInvoiceId) {
    this.preInvoiceId = preInvoiceId;
    return this;
  }

   /**
   * 预制发票id
   * @return preInvoiceId
  **/
  @ApiModelProperty(value = "预制发票id")
  public Long getPreInvoiceId() {
    return preInvoiceId;
  }

  public void setPreInvoiceId(Long preInvoiceId) {
    this.preInvoiceId = preInvoiceId;
  }

  @JsonIgnore
  public BillOfPreInvoiceRequest salesbillId(Long salesbillId) {
    this.salesbillId = salesbillId;
    return this;
  }

  /**
   * 预制发票id
   * @return salesbillId
   **/
  @ApiModelProperty(value = "单据Id")
  public Long getSalesbillId() {
    return salesbillId;
  }

  public void setSalesbillId(Long salesbillId) {
    this.salesbillId = salesbillId;
  }

  @JsonIgnore
  public BillOfPreInvoiceRequest pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * 页码
   * @return pageNo
  **/
  @ApiModelProperty(value = "页码")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public BillOfPreInvoiceRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页数据量
   * @return pageSize
  **/
  @ApiModelProperty(value = "每页数据量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BillOfPreInvoiceRequest billOfPreInvoiceRequest = (BillOfPreInvoiceRequest) o;
    return Objects.equals(this.salesbillId, billOfPreInvoiceRequest.salesbillId) &&
        Objects.equals(this.preInvoiceId, billOfPreInvoiceRequest.preInvoiceId) &&
        Objects.equals(this.pageNo, billOfPreInvoiceRequest.pageNo) &&
        Objects.equals(this.pageSize, billOfPreInvoiceRequest.pageSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(salesbillId,preInvoiceId, pageNo, pageSize);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BillOfPreInvoiceRequest {\n");
    sb.append("    salesbillId: ").append(toIndentedString(salesbillId)).append("\n");
    sb.append("    preInvoiceId: ").append(toIndentedString(preInvoiceId)).append("\n");
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
