package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 通用全部全选条件对象
 */
@ApiModel(description = "通用全部全选条件对象")

@JsonInclude(NON_NULL)
public class Conditions {
  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("userRole")
  private Integer userRole = null;

  @JsonProperty("sort")
  private Sort sort = null;

  @JsonProperty("groups")
  private List<List<RequestField>> groups = new ArrayList<List<RequestField>>();

  private List<Sort> sortList = Lists.newArrayList();

  public void setSortList(List<Sort> sortList) {
    this.sortList = sortList;
  }

  public List<Sort> getSortList() {
    return sortList;
  }

  @JsonIgnore
  public Conditions status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 分类状态 (1-正常、2-待处理、0-已作废)
   * @return status
  **/
  @ApiModelProperty(value = "分类状态 (1-正常、2-待处理、0-已作废)")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public Conditions userRole(Integer userRole) {
    this.userRole = userRole;
    return this;
  }

   /**
   * 1-销项、2-进项
   * @return userRole
  **/
  @ApiModelProperty(value = "1-销项、2-进项")
  public Integer getUserRole() {
    return userRole;
  }

  public void setUserRole(Integer userRole) {
    this.userRole = userRole;
  }

  @JsonIgnore
  public Conditions sort(Sort sort) {
    this.sort = sort;
    return this;
  }

   /**
   * Get sort
   * @return sort
  **/
  @ApiModelProperty(value = "")
  public Sort getSort() {
    return sort;
  }

  public void setSort(Sort sort) {
    this.sort = sort;
  }

  @JsonIgnore
  public Conditions groups(List<List<RequestField>> groups) {
    this.groups = groups;
    return this;
  }

  public Conditions addGroupsItem(List<RequestField> groupsItem) {
    this.groups.add(groupsItem);
    return this;
  }

   /**
   * 过滤器条件
   * @return groups
  **/
  @ApiModelProperty(value = "过滤器条件")
  public List<List<RequestField>> getGroups() {
    return groups;
  }

  public void setGroups(List<List<RequestField>> groups) {
    this.groups = groups;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Conditions conditions = (Conditions) o;
    return Objects.equals(this.status, conditions.status) &&
        Objects.equals(this.userRole, conditions.userRole) &&
        Objects.equals(this.sort, conditions.sort) &&
        Objects.equals(this.groups, conditions.groups);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, userRole, sort, groups);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Conditions {\n");

    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    userRole: ").append(toIndentedString(userRole)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
