package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonInclude(NON_NULL)
public class ExportInvoicePDFRequest {
    @JsonProperty("conditions")
    private Conditions conditions = null;

    @JsonProperty("isAllSelected")
    private Boolean isAllSelected = null;

    @JsonProperty("includes")
    private List<Long> includes = new ArrayList<Long>();

    @JsonProperty("excludes")
    private List<Long> excludes = new ArrayList<Long>();

    @JsonProperty("exportModel")
    private Integer exportModel = null;

    @JsonProperty("mergeType")
    @ApiModelProperty(value = "合并类型0-不合并导出 1-全部合并导出 2-按销方合并导出 3-按购方合并导出")
    private Integer mergeType = 0;

    @ApiModelProperty("导出文件类型")
    private List<ExportFileType> fileTypeList;

    @ApiModelProperty("请求来源 90-协同 qn-千牛 其它-平台")
    private String requestSource;

    @ApiModelProperty("销方租户id")
    private Long sellerGroupId;

    private Boolean ignoreTokenTenant = false;
}
