package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * @author <a href="mail to: libaozhong@xforceplus.com" rel="nofollow">libaozhong</a>
 * @Description: [功能描述]
 * @version: 1.0
 * @CreateDate: 2019-08-08 13:03</p>
 */
@ApiModel(description = "红字信息申请信息")

@JsonInclude(NON_NULL)
@Data
public class InvSellerRedNotificationLogDto {

    private Long id;

    /**
     * 单据来源1 销方 2购方
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : user_role
     */
    private Integer userRole;
    /**
     * 申请类型1-销方申请,2-购方申请——未抵扣,3-购方申请——已抵扣
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : apply_type
     */
    private Integer applyType;
    /**
     * 票据id p票据类型为 1是发票，2 是预制发票
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : invoice_id
     */
    @ApiModelProperty(value = "票据id")
    @JsonProperty("invoiceId")
    private Long invoiceId;
    /**
     * 0.删除，1申请中，2，申请成功，3申请失
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : status
     */
    @ApiModelProperty(value = "0.删除，1申请中，2，申请成功，3申请失")
    @JsonProperty("status")
    private Integer status;
    /**
     * 红字信息表编号
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : red_notification_no
     */
    @ApiModelProperty(value = "红字信息表编号 或 红字确认单编号")
    @JsonProperty("redNotificationNo")
    private String redNotificationNo;
    /**
     * 票据类型，1.发票，2 预制发票
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : invoice_type
     */
    @ApiModelProperty(value = "票据类型，1.发票，2 预制发票")
    @JsonProperty("invoiceType")
    private Integer invoiceType;
    /**
     * 修改时间
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : update_time
     */
    @ApiModelProperty(value = "修改时间")
    @JsonProperty("updateTime")
    private Date updateTime;
    /**
     * c创建用户id
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : create_user_id
     */
    @ApiModelProperty(value = "c创建用户id")
    @JsonProperty("createUserId")
    private Long createUserId;
    /**
     * 更新用户id
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : update_user_id
     */
    @ApiModelProperty(value = "更新用户id")
    @JsonProperty("updateUserId")
    private Long updateUserId;
    /**
     * 设备唯一编码
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : device_un
     */
    @ApiModelProperty(value = "设备唯一编码")
    @JsonProperty("deviceUn")
    private String deviceUn;
    /**
     * 终端唯一吗
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : terminal_un
     */
    @ApiModelProperty(value = "终端唯一吗")
    @JsonProperty("terminalUn")
    private String terminalUn;
    /**
     * 1,协同 2通用
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : invoice_department
     */
    @ApiModelProperty(value = "1,协同 2通用")
    @JsonProperty("invoiceDepartment")
    private Integer invoiceDepartment;
    @ApiModelProperty(value = "创建时间")
    @JsonProperty("createTime")
    private Date createTime;

    /**
     * 如果是红字确认单时 applyStatus 才有意义
     * 表 : inv_seller_red_notifucation_log
     * 对应字段 : applyStatus
     */
    @ApiModelProperty(value = "00-未申请/申请失败，01-无需确认，02-销方录入待购方确认，03-购方录入待销方确认 04-购销双方已确认 05-作废（销方录入购方否认）06-作废（购方录入销方否认） 07-作废（超72小时未确认）08-发起方撤销")
    @JsonProperty("applyStatus")
    private String applyStatus;

    /**
     * 如果是红字信息表时 applyingStatus 才有意义
     */
    @ApiModelProperty(value = "")
    private Integer applyingStatus;

}
