package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * InvoiceSendFPGJRequest
 */

@JsonInclude(NON_NULL)
public class InvoiceSendFPGJRequest {

  @ApiModelProperty("通过管家下发第三方的发票信息")
  private List<InvoiceSendToFPGJ> invoiceSendToFPGJList;

  public List<InvoiceSendToFPGJ> getInvoiceSendToFPGJList() {
    return invoiceSendToFPGJList;
  }

  public void setInvoiceSendToFPGJList(List<InvoiceSendToFPGJ> invoiceSendToFPGJList) {
    this.invoiceSendToFPGJList = invoiceSendToFPGJList;
  }

  public String checkInfo() {
    if (CollectionUtils.isEmpty(invoiceSendToFPGJList)) {
      return "参数不能为空";
    }
    boolean isError = invoiceSendToFPGJList.stream()
            .anyMatch(invoice -> StringUtils.isEmpty(invoice.getInvoiceNo()) || Objects.isNull(invoice.getSellerGroupId()));
    if (isError) {
      return "发票号码和租户不可为空";
    }
    return null;
  }
}
