package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@ApiModel("根据业务单id批量开具")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MakeOutByBizOrderIdRequest {
    @ApiModelProperty("业务单id集合")
    private List<String> bizOrderIds;

    @ApiModelProperty("是否校验终端的人员权限")
    private boolean checkTerminalAuthority = false;

    @ApiModelProperty("是否过滤不可开具的")
    private Boolean filterIllegal = false;
}
