package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票开票信息
 */
@ApiModel(description = "预制发票开票信息")
@JsonInclude(NON_NULL)
@Data
public class MakeOutPreInvoiceInfo {
    @JsonProperty("deviceId")
    @NotNull
    private Long deviceId;
    @ApiModelProperty(value = "设备唯一码 单盘必填")
    private String deviceUn;
    @JsonProperty("terminalId")
    @NotNull
    private Long terminalId;
    @ApiModelProperty(value = "终端唯一码")
    private String terminalUn;
    @ApiModelProperty(value = "开票模式, 1=单盘，2=服务器")
    @NotNull
    private String terminalType;
    @JsonProperty("preInvoiceIds")
    @NotEmpty
    private List<Long> preInvoiceIds;
    @JsonProperty("leftPreInvoiceIds")
    private List<Long> leftPreInvoiceIds;
    @JsonProperty("tenantNo")
    private String tenantNo = null;
    @JsonProperty("companyId")
    private String companyId = null;
    @ApiModelProperty("最新公司名称")
    private String newCompanyName;
    @JsonProperty("nextInvoiceNo")
    private String nextInvoiceNo = null;

    @JsonProperty("nextInvoiceCode")
    private String nextInvoiceCode = null;

    @ApiModelProperty(value = "开票人")
    private String backupDrawer;
    @JsonProperty("terminalCode")
    @ApiModelProperty(value = "终端编码")
    private String terminalCode;
    @ApiModelProperty(value = "税件重试追踪号码")
    private String retryTraceNo;
    @ApiModelProperty(value = "销方银行")
    private Boolean sellerControl;
    @ApiModelProperty(value = "购方银行")
    private Boolean purchaserControl;
    @ApiModelProperty(value = "销方地址电话")
    private Boolean sellerAddressTelControl;
    @ApiModelProperty(value = "购方地址电话")
    private Boolean purchaserAddressTelControl;
    @ApiModelProperty("上方的销方银行、购方银行控制项，是否从配置从获取。true-查配置获取；false-用户指定")
    private Boolean sellerPurchaserControlFromRule;
    @JsonProperty("sort")
    @ApiModelProperty(value = "排序字段")
    private List<Sort> sort;
    @JsonProperty("issuer")
    @ApiModelProperty(value = "数电开票人")
    private String issuer;
    @JsonProperty("isNaturalSystemFlag")
    @ApiModelProperty(value = "是否乐企标识")
    private Boolean isNaturalSystemFlag;
    @ApiModelProperty("部署类型 3-国信")
    private Integer deployType;
    @ApiModelProperty("数电是否允许混合票种开具")
    private Boolean isMultiInvoiceType = false;
    @ApiModelProperty("请求来源")
    private String requestSource;
    @ApiModelProperty("任务id")
    private Long taskId;
    @ApiModelProperty("是否为指定开票人")
    private Boolean isAppointedIssuer = false;
    @ApiModelProperty("租户id")
    private Long sellerGroupId;
    @ApiModelProperty("是否强制反算税额，true-是，false-否")
    private Boolean qdForceBackCalculateTaxAmount = false;
    @ApiModelProperty("是否在查询红票，理论上只有红字确认单自己申请的无需确认场景，该字段会有值")
    private Boolean isQueryingRedInvoice;
    @ApiModelProperty("数电开票是否传递复核人、收款人")
    private Boolean qdPassOperator = null;
    @ApiModelProperty("是否过滤不可开具的")
    private Boolean filterIllegal = false;

    @ApiModelProperty("是否稍后自动开票")
    private Boolean isDelayedInvoicing = false;
}
