package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetRedNoDetailRequest {
  @JsonProperty("businessBillType")
  private String businessBillType = null;

  @JsonProperty("userRole")
  private String userRole = null;

  @JsonProperty("id")
  private Long id = null;

  @JsonIgnore
  public MsGetRedNoDetailRequest businessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
    return this;
  }

   /**
   * AP：购方 AR-销方
   * @return businessBillType
  **/
  @ApiModelProperty(value = "AP：购方 AR-销方")
  public String getBusinessBillType() {
    return businessBillType;
  }

  public void setBusinessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
  }

  @JsonIgnore
  public MsGetRedNoDetailRequest userRole(String userRole) {
    this.userRole = userRole;
    return this;
  }

   /**
   * 1 销方 2购方
   * @return userRole
  **/
  @ApiModelProperty(value = "1 销方 2购方")
  public String getUserRole() {
    return userRole;
  }

  public void setUserRole(String userRole) {
    this.userRole = userRole;
  }

  @JsonIgnore
  public MsGetRedNoDetailRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * ID
   * @return id
  **/
  @ApiModelProperty(value = "ID")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRedNoDetailRequest getRedNoDetailRequest = (MsGetRedNoDetailRequest) o;
    return Objects.equals(this.businessBillType, getRedNoDetailRequest.businessBillType) &&
        Objects.equals(this.userRole, getRedNoDetailRequest.userRole) &&
        Objects.equals(this.id, getRedNoDetailRequest.id);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessBillType, userRole, id);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRedNoDetailRequest {\n");

    sb.append("    businessBillType: ").append(toIndentedString(businessBillType)).append("\n");
    sb.append("    userRole: ").append(toIndentedString(userRole)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
