package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetRedNoListByByBillRequest {
  @JsonProperty("businessBillType")
  private String businessBillType = null;

  @JsonProperty("userRole")
  private String userRole = null;

  @JsonProperty("applyingStatus")
  private Integer applyingStatus = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("billNo")
  private String billNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("applyTaxNo")
  private String applyTaxNo = null;

  @JsonProperty("applyStatus")
  private Integer applyStatus = null;

  @JsonProperty("sellerNo")
  private String sellerNo ;

  @JsonProperty("purchaserNo")
  private String purchaserNo ;

  @ApiModelProperty("搜索查询范围")
  private List<Long> createTime;

  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("requestBillNo")
  private String requestBillNo = null;

  @Getter
  @Setter
  private String sellerName;

  @Getter
  @Setter
  private String purchaserName;

  @JsonIgnore
  public MsGetRedNoListByByBillRequest businessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
    return this;
  }

   /**
   * AP：购方 AR-销方
   * @return businessBillType
  **/
  @ApiModelProperty(value = "AP：购方 AR-销方")
  public String getBusinessBillType() {
    return businessBillType;
  }

  public void setBusinessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
  }

  @JsonIgnore
  public MsGetRedNoListByByBillRequest userRole(String userRole) {
    this.userRole = userRole;
    return this;
  }

   /**
   * 1 销方 2购方
   * @return userRole
  **/
  @ApiModelProperty(value = "1 销方 2购方")
  public String getUserRole() {
    return userRole;
  }

  public void setUserRole(String userRole) {
    this.userRole = userRole;
  }

  @JsonIgnore
  public MsGetRedNoListByByBillRequest applyingStatus(Integer applyingStatus) {
    this.applyingStatus = applyingStatus;
    return this;
  }

   /**
   * 申请状态:1 未申请 2.申请中 3.已申请 4.全部
   * @return applyingStatus
  **/
  @ApiModelProperty(value = "申请状态:1 未申请 2.申请中 3.已申请 4.全部")
  public Integer getApplyingStatus() {
    return applyingStatus;
  }

  public void setApplyingStatus(Integer applyingStatus) {
    this.applyingStatus = applyingStatus;
  }

  @JsonIgnore
  public MsGetRedNoListByByBillRequest sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MsGetRedNoListByByBillRequest purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsGetRedNoListByByBillRequest billNo(String billNo) {
    this.billNo = billNo;
    return this;
  }

   /**
   * 业务单号
   * @return billNo
  **/
  @ApiModelProperty(value = "业务单号")
  public String getBillNo() {
    return billNo;
  }

  public void setBillNo(String billNo) {
    this.billNo = billNo;
  }

  @JsonIgnore
  public MsGetRedNoListByByBillRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsGetRedNoListByByBillRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsGetRedNoListByByBillRequest applyTaxNo(String applyTaxNo) {
    this.applyTaxNo = applyTaxNo;
    return this;
  }

   /**
   * 红字信息表编号
   * @return applyTaxNo
  **/
  @ApiModelProperty(value = "红字信息表编号")
  public String getApplyTaxNo() {
    return applyTaxNo;
  }

  public void setApplyTaxNo(String applyTaxNo) {
    this.applyTaxNo = applyTaxNo;
  }

  @JsonIgnore
  public MsGetRedNoListByByBillRequest applyStatus(Integer applyStatus) {
    this.applyStatus = applyStatus;
    return this;
  }

   /**
   * 申请状态:1. 审核通过,2. 审核不通过,3. 已核销,4. 已撤销,5.其他：其他状态？？？
   * @return applyStatus
  **/
  @ApiModelProperty(value = "申请状态:1. 审核通过,2. 审核不通过,3. 已核销,4. 已撤销,5.其他：其他状态？？？")
  public Integer getApplyStatus() {
    return applyStatus;
  }

  public void setApplyStatus(Integer applyStatus) {
    this.applyStatus = applyStatus;
  }

  @JsonIgnore
  public MsGetRedNoListByByBillRequest createTime(List<Long> createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public List<Long> getCreateTime() {
    return createTime;
  }

  public void setCreateTime(List<Long> createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsGetRedNoListByByBillRequest pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * return pageno
   * @return pageNo
  **/
  @ApiModelProperty(value = "return pageno")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public MsGetRedNoListByByBillRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

  public String getSellerNo() {
    return sellerNo;
  }

  public void setSellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
  }

  public String getPurchaserNo() {
    return purchaserNo;
  }

  public void setPurchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
  }

  /**
   * return pagesize
   * @return pageSize
  **/
  @ApiModelProperty(value = "return pagesize")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  public String getRequestBillNo() {
    return requestBillNo;
  }

  public void setRequestBillNo(String requestBillNo) {
    this.requestBillNo = requestBillNo;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRedNoListByByBillRequest getRedNoListByByBillRequest = (MsGetRedNoListByByBillRequest) o;
    return Objects.equals(this.businessBillType, getRedNoListByByBillRequest.businessBillType) &&
        Objects.equals(this.userRole, getRedNoListByByBillRequest.userRole) &&
        Objects.equals(this.applyingStatus, getRedNoListByByBillRequest.applyingStatus) &&
        Objects.equals(this.sellerTaxNo, getRedNoListByByBillRequest.sellerTaxNo) &&
        Objects.equals(this.purchaserTaxNo, getRedNoListByByBillRequest.purchaserTaxNo) &&
        Objects.equals(this.billNo, getRedNoListByByBillRequest.billNo) &&
        Objects.equals(this.invoiceCode, getRedNoListByByBillRequest.invoiceCode) &&
        Objects.equals(this.invoiceNo, getRedNoListByByBillRequest.invoiceNo) &&
        Objects.equals(this.applyTaxNo, getRedNoListByByBillRequest.applyTaxNo) &&
        Objects.equals(this.applyStatus, getRedNoListByByBillRequest.applyStatus) &&
        Objects.equals(this.createTime, getRedNoListByByBillRequest.createTime) &&
        Objects.equals(this.pageNo, getRedNoListByByBillRequest.pageNo) &&
        Objects.equals(this.pageSize, getRedNoListByByBillRequest.pageSize)&&
        Objects.equals(this.requestBillNo, getRedNoListByByBillRequest.requestBillNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessBillType, userRole, applyingStatus, sellerTaxNo, purchaserTaxNo, billNo, invoiceCode, invoiceNo, applyTaxNo, applyStatus, createTime, pageNo, pageSize);
  }


  @Override
  public String toString() {
    return "MsGetRedNoListByByBillRequest{" +
            "businessBillType='" + businessBillType + '\'' +
            ", userRole='" + userRole + '\'' +
            ", applyingStatus=" + applyingStatus +
            ", sellerTaxNo='" + sellerTaxNo + '\'' +
            ", purchaserTaxNo='" + purchaserTaxNo + '\'' +
            ", billNo='" + billNo + '\'' +
            ", invoiceCode='" + invoiceCode + '\'' +
            ", invoiceNo='" + invoiceNo + '\'' +
            ", applyTaxNo='" + applyTaxNo + '\'' +
            ", applyStatus=" + applyStatus +
            ", sellerNo='" + sellerNo + '\'' +
            ", purchaserNo='" + purchaserNo + '\'' +
            ", createTime='" + createTime + '\'' +
            ", pageNo=" + pageNo +
            ", pageSize=" + pageSize +
            '}';
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
