package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 返回详情
 */
@ApiModel(description = "返回详情")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetRedNoListByByBillResponseResult {
  @JsonProperty("billTotal")
  private Long billTotal = null;

  @JsonProperty("total")
  private Long total = null;

  @JsonProperty("totalAmountWithoutTax")
  private BigDecimal totalAmountWithoutTax = null;

  @JsonProperty("totalAmountWithTax")
  private BigDecimal totalAmountWithTax = null;

  @JsonProperty("list")
  private List<MsSysRedNoByBillDto> list = new ArrayList<MsSysRedNoByBillDto>();

  @JsonIgnore
  public MsGetRedNoListByByBillResponseResult billTotal(Long billTotal) {
    this.billTotal = billTotal;
    return this;
  }

   /**
   * return total
   * @return billTotal
  **/
  @ApiModelProperty(value = "return total")
  public Long getBillTotal() {
    return billTotal;
  }

  public void setBillTotal(Long billTotal) {
    this.billTotal = billTotal;
  }

  @JsonIgnore
  public MsGetRedNoListByByBillResponseResult total(Long total) {
    this.total = total;
    return this;
  }

   /**
   * return total
   * @return total
  **/
  @ApiModelProperty(value = "return total")
  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  @JsonIgnore
  public MsGetRedNoListByByBillResponseResult totalAmountWithoutTax(BigDecimal totalAmountWithoutTax) {
    this.totalAmountWithoutTax = totalAmountWithoutTax;
    return this;
  }

   /**
   * 合计金额
   * @return totalAmountWithoutTax
  **/
  @ApiModelProperty(value = "合计金额")
  public BigDecimal getTotalAmountWithoutTax() {
    return totalAmountWithoutTax;
  }

  public void setTotalAmountWithoutTax(BigDecimal totalAmountWithoutTax) {
    this.totalAmountWithoutTax = totalAmountWithoutTax;
  }

  @JsonIgnore
  public MsGetRedNoListByByBillResponseResult totalAmountWithTax(BigDecimal totalAmountWithTax) {
    this.totalAmountWithTax = totalAmountWithTax;
    return this;
  }

   /**
   * 总价税合计
   * @return totalAmountWithTax
  **/
  @ApiModelProperty(value = "总价税合计")
  public BigDecimal getTotalAmountWithTax() {
    return totalAmountWithTax;
  }

  public void setTotalAmountWithTax(BigDecimal totalAmountWithTax) {
    this.totalAmountWithTax = totalAmountWithTax;
  }

  @JsonIgnore
  public MsGetRedNoListByByBillResponseResult list(List<MsSysRedNoByBillDto> list) {
    this.list = list;
    return this;
  }

  public MsGetRedNoListByByBillResponseResult addListItem(MsSysRedNoByBillDto listItem) {
    this.list.add(listItem);
    return this;
  }

   /**
   * 返回详情
   * @return list
  **/
  @ApiModelProperty(value = "返回详情")
  public List<MsSysRedNoByBillDto> getList() {
    return list;
  }

  public void setList(List<MsSysRedNoByBillDto> list) {
    this.list = list;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRedNoListByByBillResponseResult getRedNoListByByBillResponseResult = (MsGetRedNoListByByBillResponseResult) o;
    return Objects.equals(this.billTotal, getRedNoListByByBillResponseResult.billTotal) &&
        Objects.equals(this.total, getRedNoListByByBillResponseResult.total) &&
        Objects.equals(this.totalAmountWithoutTax, getRedNoListByByBillResponseResult.totalAmountWithoutTax) &&
        Objects.equals(this.totalAmountWithTax, getRedNoListByByBillResponseResult.totalAmountWithTax) &&
        Objects.equals(this.list, getRedNoListByByBillResponseResult.list);
  }

  @Override
  public int hashCode() {
    return Objects.hash(billTotal, total, totalAmountWithoutTax, totalAmountWithTax, list);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRedNoListByByBillResponseResult {\n");

    sb.append("    billTotal: ").append(toIndentedString(billTotal)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    totalAmountWithoutTax: ").append(toIndentedString(totalAmountWithoutTax)).append("\n");
    sb.append("    totalAmountWithTax: ").append(toIndentedString(totalAmountWithTax)).append("\n");
    sb.append("    list: ").append(toIndentedString(list)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
