package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 发票协同请求
 */
@JsonInclude(NON_NULL)
public class MsInvoiceCollaborationRequest {

	/**
	 * 发票代码
	 */
	@JsonProperty("invoiceCode")
	private String invoiceCode;

	/**
	 * 发票号码
	 */
	@JsonProperty("invoiceNo")
	private String invoiceNo;

	/**
	 * 11-销方协同直连
	 */
	@JsonProperty("reqFrom")
	private Integer reqFrom;

	/**
	 * 触发事件 1-开票 2-红冲 3-作废
	 */
	@JsonProperty("eventType")
	private String eventType;

	public String getEventType() {
		return eventType;
	}

	public void setEventType(String eventType) {
		this.eventType = eventType;
	}

	public Integer getReqFrom() {
		return reqFrom;
	}

	public void setReqFrom(Integer reqFrom) {
		this.reqFrom = reqFrom;
	}

	public String getInvoiceCode() {
		return invoiceCode;
	}

	public void setInvoiceCode(String invoiceCode) {
		this.invoiceCode = invoiceCode;
	}

	public String getInvoiceNo() {
		return invoiceNo;
	}

	public void setInvoiceNo(String invoiceNo) {
		this.invoiceNo = invoiceNo;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		MsInvoiceCollaborationRequest obj = (MsInvoiceCollaborationRequest) o;
		return Objects.equals(this.invoiceNo, obj.invoiceNo) && Objects.equals(this.invoiceCode, obj.invoiceCode)
				&& Objects.equals(this.reqFrom, obj.reqFrom);
	}

	@Override
	public int hashCode() {
		return Objects.hash(invoiceCode, invoiceNo, reqFrom);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("class MsInvoiceCollaborationRequest {\n");
		sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
		sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
		sb.append("    reqFrom: ").append(toIndentedString(reqFrom)).append("\n");
		sb.append("}");
		return sb.toString();
	}

	/**
	 * Convert the given object to string with each line indented by 4 spaces
	 * (except the first line).
	 */
	private String toIndentedString(Object o) {
		if (o == null) {
			return "null";
		}
		return o.toString().replace("\n", "\n    ");
	}
}
