package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * OutCheckInvoicesByIdsRequest
 */

@JsonInclude(NON_NULL)
public class OutCheckInvoicesByIdsRequest {


  @JsonProperty("status")
  private String status = null;

  @ApiModelProperty("invoiceIds")
  private List<Long> invoiceIds = new ArrayList<Long>();


  @JsonIgnore
  public OutCheckInvoicesByIdsRequest status(String status) {
    this.status = status;
    return this;
  }

   /**
   * 外部批次审核状态 1-成功 0-失败
   * @return status
  **/
  @ApiModelProperty(value = "外部批次审核状态 1-成功 0-失败")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

   /**
   * 发票序列号主键列表
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "发票序列号主键列表")
  public List<Long> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OutCheckInvoicesByIdsRequest lockInvoiceRequest = (OutCheckInvoicesByIdsRequest) o;
    return  Objects.equals(this.status, lockInvoiceRequest.status) &&
        Objects.equals(this.invoiceIds, lockInvoiceRequest.invoiceIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash( status, invoiceIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OutCheckInvoicesByIdsRequest {\n");

    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
