package com.xforceplus.seller.invoice.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * PollingBaseRequest
 */

@JsonInclude(NON_NULL)
public class PollingEndRequest {

  @JsonProperty("taskId")
  private Long taskId;

  @JsonProperty("mode")
  private String mode;

  @JsonProperty("invoices")
  private List<PollingEndItemRequest> invoices = new ArrayList<>();

  public PollingEndRequest() {

  }

  public PollingEndRequest(Long taskId, String mode, List<PollingEndItemRequest> invoices) {
    this.taskId = taskId;
    this.mode = mode;
    this.invoices = invoices;
  }

  public Long getTaskId() {
    return taskId;
  }

  public void setTaskId(Long taskId) {
    this.taskId = taskId;
  }

  public String getMode() {
    return mode == null ? null : mode.trim();
  }

  public void setMode(String mode) {
    this.mode = mode == null ? null : mode.trim();
  }

  public List<PollingEndItemRequest> getInvoices() {
    return invoices;
  }

  public void setInvoices(List<PollingEndItemRequest> invoices) {
    this.invoices = invoices;
  }
}
