package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@ApiModel
public class PreviewInvoiceRequest {

    @ApiModelProperty(value = "预制发票id")
    private List<Long> preInvoiceIds;

    @ApiModelProperty(value = "单据id集合")
    private List<Long> salesBillIds;

    @ApiModelProperty(value = "协同：90")
    private String requestSource;

    @ApiModelProperty(value = "操作类型：1只查询预制发票，2只预制发票和明细，3查询预制发票和发票状态，4查询所有包括状态")
    private String previewMode;

    @ApiModelProperty(value = "销方id")
    private Long sellerTenantId;

    public Long getSellerTenantId() {
        return sellerTenantId;
    }

    public void setSellerTenantId(Long sellerTenantId) {
        this.sellerTenantId = sellerTenantId;
    }

    public String getRequestSource() {
        return requestSource;
    }

    public void setRequestSource(String requestSource) {
        this.requestSource = requestSource;
    }

    public List<Long> getPreInvoiceIds() {
        return preInvoiceIds;
    }

    public void setPreInvoiceIds(List<Long> preInvoiceIds) {
        this.preInvoiceIds = preInvoiceIds;
    }

    public List<Long> getSalesBillIds() {
        return salesBillIds;
    }

    public void setSalesBillIds(List<Long> salesBillIds) {
        this.salesBillIds = salesBillIds;
    }

    public String getPreviewMode() {
        return previewMode;
    }

    public void setPreviewMode(String previewMode) {
        this.previewMode = previewMode;
    }
}
