package com.xforceplus.seller.invoice.client.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class QuerySmartMatchInvoiceRequest implements Serializable {
    private String priceMethod;
    private List<InvoiceMatchDto> invoiceMatchList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class InvoiceMatchDto implements Serializable {
        private Long invoiceId;
        private List<ItemMatchDto> itemMatchList;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ItemMatchDto implements Serializable {
        private Long itemId;
        private BigDecimal amount;
        // 废弃 amount 字段，改用如下字段
        private BigDecimal amountWithoutTax;
        private BigDecimal amountWithTax;
        private BigDecimal quantity;
    }
}
