package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * @author <a href="mail to: libaozhong@xforceplus.com" rel="nofollow">libaozhong</a>
 * @Description: [功能描述]
 * @version: 1.0
 * @CreateDate: 2019-08-09 13:32</p>
 */
@JsonInclude(NON_NULL)
public class RedNoApplyRequest {

    public InvSellerRedNotificationLogDto getInvSellerRedNotificationLogDto() {
        return invSellerRedNotificationLogDto;
    }

    public void setInvSellerRedNotificationLogDto(InvSellerRedNotificationLogDto invSellerRedNotificationLogDto) {
        this.invSellerRedNotificationLogDto = invSellerRedNotificationLogDto;
    }

    @ApiModelProperty(value = "申请信息")
    @JsonProperty("invSellerRedNotifucationLogDto")
    private InvSellerRedNotificationLogDto invSellerRedNotificationLogDto;
    @ApiModelProperty(value = "票据信息")
    @JsonProperty("sellerInvoiceInfo")
    private SellerInvoiceInfo sellerInvoiceInfo;

    @ApiModelProperty(value = "详情信息")
    @JsonProperty("invoiceItemList")
    private List<InvoiceItem> invoiceItemList = new ArrayList<InvoiceItem>();


    public SellerInvoiceInfo getSellerInvoiceInfo() {
        return sellerInvoiceInfo;
    }

    public void setSellerInvoiceInfo(SellerInvoiceInfo sellerInvoiceInfo) {
        this.sellerInvoiceInfo = sellerInvoiceInfo;
    }

    public List<InvoiceItem> getInvoiceItemList() {
        return invoiceItemList;
    }

    public void setInvoiceItemList(List<InvoiceItem> invoiceItemList) {
        this.invoiceItemList = invoiceItemList;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RedNoApplyRequest that = (RedNoApplyRequest) o;
        return Objects.equals(invSellerRedNotificationLogDto, that.invSellerRedNotificationLogDto) &&
                Objects.equals(sellerInvoiceInfo, that.sellerInvoiceInfo) &&
                Objects.equals(invoiceItemList, that.invoiceItemList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(invSellerRedNotificationLogDto, sellerInvoiceInfo, invoiceItemList);
    }
}
