package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@JsonInclude(NON_NULL)
@Data
public class ResendMakeOutInvoiceRequest {
    @ApiModelProperty(value = "预制发票id")
    @JsonProperty("preInvoiceIdList")
    private List<Long> preInvoiceIdList;

    @ApiModelProperty(value = "终端信息")
    @JsonProperty("resendTerminalInfo")
    private ResendTerminalInfo resendTerminalInfo;

    @ApiModelProperty(value = "任务Id")
    @JsonProperty("taskId")
    private Long taskId;

    @ApiModelProperty(value = "租户id")
    @JsonProperty("sellerGroupId")
    private Long sellerGroupId;


}