package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/8/1 16:48
 */
@JsonInclude(NON_NULL)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SplitPreInvoiceRequest {

    /**
     * 单据信息
     */
    @NotNull(message = "单据信息不能为空")
    @JsonProperty("billInfo")
    @ApiModelProperty("单据信息")
    private BillInfo billInfo;

    @ApiModelProperty(value = "协同：90")
    @JsonProperty("requestSource")
    private String requestSource;

    @ApiModelProperty(value = "是否强制反算税额（放开给销协融合传递）")
    @JsonProperty("forceBackCalculateTaxAmount")
    private Boolean forceBackCalculateTaxAmount = false;

    @JsonProperty("mergeType")
    @ApiModelProperty("合并类型 0-无组合合并 1-自动组合 2-自动合并")
    private int mergeType;

    /**
     * 拆票规则
     */
    @NotNull(message = "拆票规则不能为空")
    @JsonProperty("splitRule")
    @ApiModelProperty("拆票规则")
    private SplitRule splitRule;

    @JsonProperty("batchNo")
    @ApiModelProperty("批次号")
    private Long batchNo;

    /**
     * 自动开具终端代码
     */
    @JsonProperty("terminalCode")
    @ApiModelProperty("自动开具终端代码")
    private String terminalCode;
    /**
     * 自动开具终端名称
     */
    @JsonProperty("terminalName")
    @ApiModelProperty("自动开具终端代码")
    private String terminalName;

    @JsonProperty("splitType")
    @ApiModelProperty("自动拆票flag 0-手动拆票 1-自动拆票")
    private int splitType;

    @JsonProperty("operatorUser")
    @ApiModelProperty("操作人")
    private String operatorUser;

    @JsonProperty("autoMakesalesBillIds")
    @ApiModelProperty("自动开票业务单id")
    List<Long> autoMakesalesBillIds;
    @JsonProperty("makingReason")
    @ApiModelProperty("开具红冲原因")
    private String makingReason;
    /**
     * 请求任务id 不用传
     */
    private Long taskId;

    /**
     *拆票预览 false
     * 通过单号拆票 true
     */
    private Boolean saveDbFlag;

    @ApiModelProperty("手工开票填写的发票备注（有值时替换拆票备注）")
    private String invoiceRemark;

    @ApiModelProperty("是否自动生成红字信息表/红字确认单")
    private Boolean autoApplyRedLetter;

    @ApiModelProperty("是否使用拆票服务 null 或 true - 走拆票服务  false - 不走拆票服务")
    private Boolean isUsingSplitService = null;

    @ApiModelProperty("下一张发票号码")
    private String nextInvoiceNo;
    @ApiModelProperty("下一张发票代码")
    private String nextInvoiceCode;

    /**
     * 0709迭代仅适用与 splitType = 8 的自动请红字确认单的改造；其他场景未适配
     */
    @ApiModelProperty("是否乐企")
    private Boolean isNaturalSystemFlag;

    /**
     ** true  - 发起拆票拦截
     ** false - 发起拆票不拦截（默认）
     */
    @ApiModelProperty("0税率不可以开具专票")
    private Boolean zeroTaxRateNotAllowMakeSpecialInvoice = false;

    public Boolean getIsUsingSplitService() {
        return null == isUsingSplitService || isUsingSplitService;
    }

    private BillNotSplitRuleAttr notSplitRuleAttr;
}
