package com.xforceplus.seller.invoice.client.model.invoice;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class QueryInvoiceDetailsByEsResultDTO {
    private List<InvoiceDetailDTO> details;
    private PaginationDTO pagination;

    @Data
    public static class InvoiceDetailDTO {
        private Long id;

        @JSONField(serialize = false)
        private Long invoiceId;

        private String sellerTaxNo;
        private String sellerName;
        private String invoiceType;
        private String allElectricInvoiceNo;
        private String invoiceCode;
        private String invoiceNo;
        private String paperDrawDate;
        private String goodsTaxNo;
        private String cargoName;
        private BigDecimal quantity;
        private String quantityUnit;
    }

    @Data
    public static class PaginationDTO {
        private Integer pageNo;
        private Integer pageSize;
        private Integer pageCount;
        private Long total;
    }
}
