package com.xforceplus.seller.invoice.client.model.invoice;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

@ApiModel("原发票信息")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class QueryOriginalInvoiceInfoResultDTO {
    @ApiModelProperty("原蓝票不含税金额（正数）")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal originalAmountWithoutTax;
    @ApiModelProperty("有效已申请的不含税金额（正数）")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal appliedAmountWithoutTax;
    @ApiModelProperty("原蓝票开票时间")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Date originalPaperDrawDate = null;
    /**
     * 特殊发票标识
     */
    private Integer specialInvoiceFlag;
}
