package com.xforceplus.seller.invoice.client.model.open;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("销方信息")
public class QuerySeller {
    @ApiModelProperty("销方集团Id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long sellerGroupId;
    @ApiModelProperty("销方公司Id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long sellerId;
    @ApiModelProperty("销方编号")
    private String sellerNo;
    @ApiModelProperty("销方名称")
    private String sellerName;
    @ApiModelProperty("销方税号")
    private String sellerTaxNo;
    @ApiModelProperty("销方电话")
    private String sellerTel;
    @ApiModelProperty("销方地址")
    private String sellerAddress;
    @ApiModelProperty("销方银行名称")
    private String sellerBankName;
    @ApiModelProperty("销方银行账号")
    private String sellerBankAccount;
}