package com.xforceplus.seller.invoice.client.model.open;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;

@ApiModel("红字明细")
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Data
public class RedLetterDetail<T> {
    @ApiModelProperty("明细金额")
    @Valid
    private T detailAmount;
    @ApiModelProperty("货物、服务信息")
    @Valid
    private RedLetterDetailItem detailItem;
    @ApiModelProperty("税收信息")
    @Valid
    private RedLetterDetailTax detailTax;
}
