package com.xforceplus.seller.invoice.client.model.open.v2.invoice;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.BeanUtils;

import java.util.List;

@Data
public class LockInvoiceResult {
    private List<LockInvoiceInfo> invoices;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class LockInvoiceInfo {
        private InvoiceCodeNo invoice;

        private String code;
        private String message;

        public LockInvoiceInfo(InvoiceCodeNo invoice) {
            this.invoice = new InvoiceCodeNo();
            BeanUtils.copyProperties(invoice, this.invoice);
        }
    }
}
