package com.xforceplus.seller.invoice.client.model.pdf;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import java.util.Objects;

public class AutoPdfInvoiceDetailInfo {
    @JsonProperty("production")
    private AutoPdfProductionInfo production = null;
    @JsonProperty("amount")
    private AutoPdfInvoiceDetailAmountInfo amount = null;
    @JsonProperty("tax")
    private AutoPdfTaxInfo tax = null;




    @JsonIgnore
    public AutoPdfInvoiceDetailInfo production(AutoPdfProductionInfo production) {
        this.production = production;
        return this;
    }

    @Valid
    @ApiModelProperty("发票明细商品或劳务信息")
    public AutoPdfProductionInfo getProduction() {
        return this.production;
    }

    public void setProduction(AutoPdfProductionInfo production) {
        this.production = production;
    }

    @JsonIgnore
    public AutoPdfInvoiceDetailInfo amount(AutoPdfInvoiceDetailAmountInfo amount) {
        this.amount = amount;
        return this;
    }

    @Valid
    @ApiModelProperty("发票明细金额信息")
    public AutoPdfInvoiceDetailAmountInfo getAmount() {
        return this.amount;
    }

    public void setAmount(AutoPdfInvoiceDetailAmountInfo amount) {
        this.amount = amount;
    }


    @JsonIgnore
    public AutoPdfInvoiceDetailInfo tax(AutoPdfTaxInfo tax) {
        this.tax = tax;
        return this;
    }

    @Valid
    @ApiModelProperty("税收信息")
    public AutoPdfTaxInfo getTax() {
        return this.tax;
    }

    public void setTax(AutoPdfTaxInfo tax) {
        this.tax = tax;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AutoPdfInvoiceDetailInfo that = (AutoPdfInvoiceDetailInfo) o;
        return Objects.equals(production, that.production) &&
                Objects.equals(amount, that.amount) &&
                Objects.equals(tax, that.tax);
    }

    @Override
    public int hashCode() {
        return Objects.hash(production, amount, tax);
    }

    @Override
    public String toString() {
        return "AutoPdfInvoiceDetailInfo{" +
                "production=" + production +
                ", amount=" + amount +
                ", tax='" + tax + '\'' +
                '}';
    }
}
