package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.PreInvoiceAndIsRetryRequest;
import com.xforceplus.seller.invoice.client.model.SellerPreInvoiceAndRetryResponse;
import com.xforceplus.seller.invoice.client.model.SellerPreInvoiceQueryResponse;
import com.xforceplus.seller.invoice.client.model.SellerPreInvoiceWithItemsResponse;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@Api(value = "billPreInvoiceOperationApi", description = "the BillPreInvoiceOperationApi API")
public interface BillPreInvoiceOperationApi {
    @ApiOperation(value = "根据业务单Id查询对应预制发票详细信息", notes = "", response = SellerPreInvoiceQueryResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询结果", response = SellerPreInvoiceQueryResponse.class)})
    @RequestMapping(value = "/preInvoice/queryPreInvoiceWithItems",
            produces = {"application/json"},
            method = RequestMethod.POST)
    SellerPreInvoiceWithItemsResponse queryPreInvoiceWithItems(@ApiParam(value = "发票查询请求") @RequestBody List<Long> salesBillIds);

    @ApiOperation(value = "根据业务单Id查询对应预制发票详细信息及是否重试开票", notes = "", response = SellerPreInvoiceQueryResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询结果", response = SellerPreInvoiceQueryResponse.class)})
    @RequestMapping(value = "/preInvoice/queryPreInvoiceAndIsRetry",
            produces = {"application/json"},
            method = RequestMethod.POST)
    SellerPreInvoiceAndRetryResponse queryPreInvoiceAndIsRetry(@ApiParam(value = "发票查询请求") @RequestBody PreInvoiceAndIsRetryRequest request);
}
