package com.xforceplus.seller.invoice.client.api;


import com.xforceplus.seller.invoice.client.model.collaborative.FailPreInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.collaborative.SendRequestModel;
import com.xforceplus.seller.invoice.client.model.collaborative.SuccRedPreInvoiceRequest;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


/**
 * 项目名称: 票易通
 * 模块名称:
 * JDK 版本: JDK1.8
 * 说明:
 * 作者(@author): wangjingshuang
 * 创建时间:
 */
@Api(value = "CollaborativeApi", description = "the CollaborativeApi API")
public interface CollaborativeApi {

    @ApiOperation(value = "单据自动开具生成预制发票失败下发", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags = {"CollaborativeApi",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = Response.class)})
    @PostMapping(value = "/deliveryFailAutoMakeOutPreInvoice", produces = { "application/json" })
    Response deliveryFailAutoMakeOutPreInvoice(@ApiParam(value = "请求体", required = true) @RequestBody FailPreInvoiceRequest failPreInvoiceRequest);


    @ApiOperation(value = "申请红字信息预制发票成功下发", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags = {"CollaborativeApi",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = Response.class)})
    @PostMapping(value = "/deliverySuccRedPreInvoice", produces = { "application/json" })
    Response deliverySuccRedPreInvoice(@ApiParam(value = "请求体", required = true) @RequestBody SuccRedPreInvoiceRequest succRedPreInvoiceRequest);



    @ApiOperation(value = "导入红字信息成功下发", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags = {"CollaborativeApi",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = Response.class)})
    @PostMapping(value = "/importSuccRedNotification", produces = { "application/json" })
    Response importSuccRedNotification(@ApiParam(value = "请求体", required = true) @RequestBody SuccRedPreInvoiceRequest succRedPreInvoiceRequest);



    @ApiOperation(value = "手动下发发票数据", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags = {"CollaborativeApi",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = Response.class)})
    @PostMapping(value = "/retrySendCooperation", produces = { "application/json" })
    Response retrySendCooperation(@ApiParam(value = "请求体", required = true) @RequestBody SendRequestModel sendRequestModel);







}
