package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.DevOpsSellerInvoiceQueryByConditionRequest;
import com.xforceplus.seller.invoice.client.model.PreInvoiceSyncRequest;
import com.xforceplus.seller.invoice.client.model.SellerInvoiceQueryByConditionRequest;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import javax.validation.constraints.NotNull;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import org.springframework.web.bind.annotation.RequestParam;

@Api(value = "invoiceDevOps", description = "the invoiceDevOps API")
public interface InvoiceDevOpsApi {

    @ApiOperation(value = "运维模块推送发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "InvoiceDevOps", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/pushInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<Object> pushInvoice(@ApiParam(value = "", required = true) @RequestBody DevOpsSellerInvoiceQueryByConditionRequest condition);

    @ApiOperation(value = "运维模块查询发票信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "InvoiceDevOps", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/getInvoiceInfo",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response getInvoiceInfo(@ApiParam(value = "", required = true) @RequestBody SellerInvoiceQueryByConditionRequest request);


    @ApiOperation(value = "生成电票pdf", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "InvoiceDevOps", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/generateEInvoicePDF",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<Object> generateEInvoicePDF(@ApiParam(value = "", required = true) @RequestBody SellerInvoiceQueryByConditionRequest request);


    @ApiOperation(value = "预制发票重推下发协同", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "InvoiceDevOps", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/sync-preInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<Object> syncPreInvoice(@RequestBody PreInvoiceSyncRequest request);


    @ApiOperation(value = "租户下发字段配置缓存清理", notes = "", response = Response.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "InvoiceDevOps", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/clearCacheByTenant",
        produces = { "application/json" },
        method = RequestMethod.GET)
    Response<Object> clearCacheByTenant(@NotNull @ApiParam(value = "租户ID", required = true) @RequestParam(value = "tenantId", required = true) Long tenantId);

}
