package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.*;
import com.xforceplus.seller.invoice.client.model.collaborative.SuccRedPreInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.redNotification.RedNotificationCooperationBackFillRequest;
import com.xforceplus.seller.invoice.client.model.redNotification.RedNotificationUpdateRequest;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "redNotification", description = "the redNotification API")
public interface RedNotificationApi {

    @ApiOperation(value = "根据红字信息编号获取开票信息", notes = "", response = MsGetRedNoIssueInfoResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {@ApiResponse(code = 200, message = "统一返回", response = MsGetRedNoIssueInfoResponse.class) })
    @RequestMapping(value = "/redNotification/getRedNoIssueInfoById",
            produces = { "application/json" },
            method = RequestMethod.POST)
    MsGetRedNoIssueInfoResponse getRedNoIssueInfoById(@ApiParam(value = "request", required = true) @RequestBody MsGetPreInvoiceByRedNoRequest request);

    @ApiOperation(value = "获取上传结果", notes = "", response = MsGetRedNoUploadResultResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MsGetRedNoUploadResultResponse.class) })
    @RequestMapping(value = "/redNotification/getRedNoUploadResult",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsGetRedNoUploadResultResponse getRedNoUploadResult(@ApiParam(value = "request", required = true) @RequestBody MsGetRedNoUploadResultRequest id);


    @ApiOperation(value = "批量提交红字信息详情", notes = "", response = MsSubmitRedNoAllResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response", response = MsSubmitRedNoAllResponse.class) })
    @RequestMapping(value = "/redNotification/submitRedNoAll",
        produces = { "application/json" },
        method = RequestMethod.POST)
     MsSubmitRedNoAllResponse submitRedNoAll(@ApiParam(value = "request", required = true) @RequestBody MsSubmitRedNoAllRequest id);


    @ApiOperation(value = "生成红字信息表pdf（根据发票）", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = Response.class) })
    @RequestMapping(value = "/redNotification/generateRedNoPdfByInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<String> generateRedNoPdfByInvoice(@ApiParam(value = "request", required = true) @RequestBody MsGenerateRedNoPdfByInvoiceRequest request);


    @ApiOperation(value = "生成红字信息表pdf（根据业务单）", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = Response.class) })
    @RequestMapping(value = "/redNotification/generateRedNoPdfByBill",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<String> generateRedNoPdfByBill(@ApiParam(value = "request", required = true) @RequestBody MsGenerateRedNoPdfByBillRequest request);


    @ApiOperation(value = "红字信息下发", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = Response.class) })
    @RequestMapping(value = "/redNotification/cooperation",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response deliverRedNotification(@ApiParam(value = "request", required = true) @RequestBody SuccRedPreInvoiceRequest request);

    @ApiOperation(value = "红字信息红字信息下发结果回填", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = Response.class) })
    @RequestMapping(value = "/redNotification/cooperationBackFill",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response cooperationBackFill(@ApiParam(value = "request", required = true) @RequestBody RedNotificationCooperationBackFillRequest request);

    @ApiOperation(value = "红字信息修改业务单号和类型", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = Response.class) })
    @RequestMapping(value = "/redNotification/updateBillNoAndType",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response updateRedNotificationBillNoAndType(@ApiParam(value = "request", required = true) @RequestBody RedNotificationUpdateRequest request);


    @ApiOperation(value = "获取根据下发结果获取红字信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = Response.class) })
    @RequestMapping(value = "/redNotification/getRedNosByCooperationResult",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<MsGetRedNoListByInvoiceResponseResult> getRedNosByCooperationResult(@ApiParam(value = "request", required = true) @RequestBody MsGetRedNoListByInvoiceRequest request);


    @ApiOperation(value = "红字信息下发结果统计", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = Response.class) })
    @RequestMapping(value = "/redNotification/getCooperationResultStatistics",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<MsRedNoCooperationResultStatisticsDto> getCooperationResultStatistics(@ApiParam(value = "request", required = true) @RequestBody MsGetRedNoListByInvoiceRequest request);

    @ApiOperation(value = "导出所有红字信息", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "redNotification", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = Response.class) })
    @RequestMapping(value = "/redNotification/param/exportRedNoAll",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<RedNotificationOpenConditionVo> queryExportRedNotificationCondition(@ApiParam(value = "request", required = true) @RequestBody RedLetterOperationRequest<Long> request);

    @ApiOperation(value = "导出业务单所有红字信息", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"redNotification",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = Response.class)})
    @RequestMapping(value = "/redNotification/param/exportBillRedNoAll",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<RedNotificationOpenConditionVo> queryExportRedNotificationConditionByBill(@ApiParam(value = "request", required = true) @RequestBody RedLetterOperationRequest<MsDeleteBillRedNoAllRequestExcludes> request);
}
