package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * AbandonInvoiceCheckRequest
 */

@JsonInclude(NON_NULL)
@Data
public class AbandonInvoiceCheckRequest {
    private Conditions conditions = null;

    @JsonProperty("isAllSelected")
    private Boolean isAllSelected = null;

    @JsonProperty("includes")
    private List<Long> includes = new ArrayList<Long>();

    @JsonProperty("excludes")
    private List<Long> excludes = new ArrayList<Long>();

    @JsonProperty("status")
    private Integer status = null;

    @JsonProperty("userRole")
    private Integer userRole = null;

    @ApiModelProperty("搜索查询范围")
    private List<Long> createTime;

    @ApiModelProperty("是否预警后继续")
    private Boolean afterAlertContinue;

    @ApiModelProperty(value = "是否线下")
    @JsonProperty("offFlag")
    private Boolean offFlag=false;

    @ApiModelProperty(value = "开票人")
    @JsonProperty("issuer")
    private String issuer;

    @ApiModelProperty(value = "数电票作废原因：invoiceError:开票有误 taxServiceEnd:服务中止 salesReturn:销货退回 other:其他")
    @JsonProperty("cancelReason")
    private String cancelReason;

    @ApiModelProperty(value = "作废详细原因（当作废原因为other时 此项必填）")
    @JsonProperty("cancelReasonDetail")
    private String cancelReasonDetail;

//  public Integer getStatus() {
//    return status;
//  }
//
//  public void setStatus(Integer status) {
//    this.status = status;
//  }
//
//  public Integer getUserRole() {
//    return userRole;
//  }
//
//  public void setUserRole(Integer userRole) {
//    this.userRole = userRole;
//  }
//
//  @JsonIgnore
//  public AbandonInvoiceCheckRequest isAllSelected(Boolean isAllSelected) {
//    this.isAllSelected = isAllSelected;
//    return this;
//  }
//
//   /**
//   * 是否全选：true-全选 false-非全选
//   * @return isAllSelected
//  **/
//  @ApiModelProperty(value = "是否全选：true-全选 false-非全选")
//  public Boolean getIsAllSelected() {
//    return isAllSelected;
//  }
//
//  public void setIsAllSelected(Boolean isAllSelected) {
//    this.isAllSelected = isAllSelected;
//  }
//
//  @JsonIgnore
//  public AbandonInvoiceCheckRequest includes(List<Long> includes) {
//    this.includes = includes;
//    return this;
//  }
//
//  public AbandonInvoiceCheckRequest addIncludesItem(Long includesItem) {
//    this.includes.add(includesItem);
//    return this;
//  }
//
//   /**
//   * 包含项-发票序列号主键列表
//   * @return includes
//  **/
//  @ApiModelProperty(value = "包含项-发票序列号主键列表")
//  public List<Long> getIncludes() {
//    return includes;
//  }
//
//  public void setIncludes(List<Long> includes) {
//    this.includes = includes;
//  }
//
//  @JsonIgnore
//  public AbandonInvoiceCheckRequest excludes(List<Long> excludes) {
//    this.excludes = excludes;
//    return this;
//  }
//
//  public AbandonInvoiceCheckRequest addExcludesItem(Long excludesItem) {
//    this.excludes.add(excludesItem);
//    return this;
//  }
//
//  public List<Long> getCreateTime() {
//    return createTime;
//  }
//
//  public void setCreateTime(List<Long> createTime) {
//    this.createTime = createTime;
//  }
//
//  /**
//   * 排除项-发票序列号主键列表
//   * @return excludes
//  **/
//  @ApiModelProperty(value = "排除项-发票序列号主键列表")
//  public List<Long> getExcludes() {
//    return excludes;
//  }
//
//  public void setExcludes(List<Long> excludes) {
//    this.excludes = excludes;
//  }
//
//
//    public Conditions getConditions() {
//        return conditions;
//    }
//
//    public void setConditions(Conditions conditions) {
//        this.conditions = conditions;
//  }
//
//    public Boolean getAllSelected() {
//        return isAllSelected;
//  }
//
//    public void setAllSelected(Boolean allSelected) {
//        isAllSelected = allSelected;
//  }
//
//  /**
//   * Convert the given object to string with each line indented by 4 spaces
//   * (except the first line).
//   */
//  private String toIndentedString(Object o) {
//    if (o == null) {
//      return "null";
//    }
//    return o.toString().replace("\n", "\n    ");
//  }

}
