package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 查询数据
 */
@ApiModel(description = "查询数据")

@JsonInclude(NON_NULL)
public class AllSelectQueryResponseResult {
  @JsonProperty("batchNo")
  private String batchNo = null;

  @JsonProperty("batchNoCount")
  private Integer batchNoCount = null;

  @JsonProperty("preInvoiceCount")
  private Integer preInvoiceCount = null;

  @JsonIgnore
  public AllSelectQueryResponseResult batchNo(String batchNo) {
    this.batchNo = batchNo;
    return this;
  }

   /**
   * 批次号
   * @return batchNo
  **/
  @ApiModelProperty(value = "批次号")
  public String getBatchNo() {
    return batchNo;
  }

  public void setBatchNo(String batchNo) {
    this.batchNo = batchNo;
  }

  @JsonIgnore
  public AllSelectQueryResponseResult batchNoCount(Integer batchNoCount) {
    this.batchNoCount = batchNoCount;
    return this;
  }

   /**
   * 批次号数量
   * @return batchNoCount
  **/
  @ApiModelProperty(value = "批次号数量")
  public Integer getBatchNoCount() {
    return batchNoCount;
  }

  public void setBatchNoCount(Integer batchNoCount) {
    this.batchNoCount = batchNoCount;
  }

  @JsonIgnore
  public AllSelectQueryResponseResult preInvoiceCount(Integer preInvoiceCount) {
    this.preInvoiceCount = preInvoiceCount;
    return this;
  }

   /**
   * 预制发票数量
   * @return preInvoiceCount
  **/
  @ApiModelProperty(value = "预制发票数量")
  public Integer getPreInvoiceCount() {
    return preInvoiceCount;
  }

  public void setPreInvoiceCount(Integer preInvoiceCount) {
    this.preInvoiceCount = preInvoiceCount;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AllSelectQueryResponseResult allSelectQueryResponseResult = (AllSelectQueryResponseResult) o;
    return Objects.equals(this.batchNo, allSelectQueryResponseResult.batchNo) &&
        Objects.equals(this.batchNoCount, allSelectQueryResponseResult.batchNoCount) &&
        Objects.equals(this.preInvoiceCount, allSelectQueryResponseResult.preInvoiceCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(batchNo, batchNoCount, preInvoiceCount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AllSelectQueryResponseResult {\n");

    sb.append("    batchNo: ").append(toIndentedString(batchNo)).append("\n");
    sb.append("    batchNoCount: ").append(toIndentedString(batchNoCount)).append("\n");
    sb.append("    preInvoiceCount: ").append(toIndentedString(preInvoiceCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
