package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.seller.config.client.model.MsTerminalQueryResponseInfo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/8/8 18:38
 */
@Data
public class AutoInvoiceRequest {

    @ApiModelProperty(value = "预制发票id")
    private List<Long> preInvoiceIdList;

    @ApiModelProperty(value = "自动开具终端编码")
    private String terminalCode;
    @ApiModelProperty(value = "自动开具终端名称")
    private String terminalName;

    @ApiModelProperty(value = "自动开具终端编码")
    private Long taskId;

    @ApiModelProperty(value = "0:正常,1:自动,2:虚拟票")
    private Integer autoInvoiceFlag;
    private Boolean isNaturalSystemFlag;
    private MsTerminalQueryResponseInfo info;
    private Boolean isAppointedIssuer;

    private String nextInvoiceNo;

    private String nextInvoiceCode;



}
