package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 基础打印发票结果
 */
@ApiModel(description = "基础打印发票结果")

@JsonInclude(NON_NULL)
@Data
public class BasePrintInvoiceResult {

    @ApiModelProperty(value = "发票打印失败总数")
    private int failedCount = 0;
    @ApiModelProperty(value = "发票打印成功总数")
    private int successCount = 0;
    @ApiModelProperty(value = "发票打印总数")
    private int printTotal = 0;

}
