package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class BatchAbandonReverseRequest {
    private List<Long> abandonInvoiceIdList;
    private List<ReverseData> reverseInvoiceList;
    private String reverseTerminalUn;
    private String reverseDeviceUn;
    private String reverseTerminalType;
    private Integer reverseDeployType;
    private String reverseIssuer;
    private String reverseReason;
    //是否乐企标识（不传默认为false，如果传为true，走乐企通道）
    private Boolean isNaturalSystemFlag;
    @ApiModelProperty("红票的国税发票来源，发票存在数电红冲税控时必填")
    private String redTaxInvoiceSource;

    @ApiModelProperty("默认不传-仅批量红冲或作废 red_issue_print-红冲并打印 ")
    private String mode = null;

    private String nextInvoiceNo;

    private String nextInvoiceCode;

    private Integer releaseType;

    private Integer operationPageFrom;

    @ApiModelProperty(value = "开票人")
    @JsonProperty("issuer")
    private String issuer;

    @ApiModelProperty(value = "数电票作废原因：invoiceError:开票有误 taxServiceEnd:服务中止 salesReturn:销货退回 other:其他")
    @JsonProperty("cancelReason")
    private String cancelReason;

    @ApiModelProperty(value = "作废详细原因（当作废原因为other时 此项必填）")
    @JsonProperty("cancelReasonDetail")
    private String cancelReasonDetail;
}
