package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票查询所属单据参数
 */
@ApiModel(description = "预制发票查询所属单据参数")

@JsonInclude(NON_NULL)
public class BillOfPreInvoice {
  @JsonProperty("billOfPreInvoiceMainInfo")
  private BillOfPreInvoiceMain billOfPreInvoiceMainInfo = null;

  @JsonProperty("billOfPreInvoiceItem")
  private BillOfPreInvoiceItem billOfPreInvoiceItem = null;

  @JsonIgnore
  public BillOfPreInvoice billOfPreInvoiceMainInfo(BillOfPreInvoiceMain billOfPreInvoiceMainInfo) {
    this.billOfPreInvoiceMainInfo = billOfPreInvoiceMainInfo;
    return this;
  }

   /**
   * Get billOfPreInvoiceMainInfo
   * @return billOfPreInvoiceMainInfo
  **/
  @ApiModelProperty(value = "")
  public BillOfPreInvoiceMain getBillOfPreInvoiceMainInfo() {
    return billOfPreInvoiceMainInfo;
  }

  public void setBillOfPreInvoiceMainInfo(BillOfPreInvoiceMain billOfPreInvoiceMainInfo) {
    this.billOfPreInvoiceMainInfo = billOfPreInvoiceMainInfo;
  }

  @JsonIgnore
  public BillOfPreInvoice billOfPreInvoiceItem(BillOfPreInvoiceItem billOfPreInvoiceItem) {
    this.billOfPreInvoiceItem = billOfPreInvoiceItem;
    return this;
  }

   /**
   * Get billOfPreInvoiceItem
   * @return billOfPreInvoiceItem
  **/
  @ApiModelProperty(value = "")
  public BillOfPreInvoiceItem getBillOfPreInvoiceItem() {
    return billOfPreInvoiceItem;
  }

  public void setBillOfPreInvoiceItem(BillOfPreInvoiceItem billOfPreInvoiceItem) {
    this.billOfPreInvoiceItem = billOfPreInvoiceItem;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BillOfPreInvoice billOfPreInvoice = (BillOfPreInvoice) o;
    return Objects.equals(this.billOfPreInvoiceMainInfo, billOfPreInvoice.billOfPreInvoiceMainInfo) &&
        Objects.equals(this.billOfPreInvoiceItem, billOfPreInvoice.billOfPreInvoiceItem);
  }

  @Override
  public int hashCode() {
    return Objects.hash(billOfPreInvoiceMainInfo, billOfPreInvoiceItem);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BillOfPreInvoice {\n");

    sb.append("    billOfPreInvoiceMainInfo: ").append(toIndentedString(billOfPreInvoiceMainInfo)).append("\n");
    sb.append("    billOfPreInvoiceItem: ").append(toIndentedString(billOfPreInvoiceItem)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
