package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 发票批次号信息
 */
@ApiModel(description = "发票号码代码")

@JsonInclude(NON_NULL)
public class InvoiceBatchNoInfo {
  @JsonProperty("outBatchNo")
  private String outBatchNo = null;

  @JsonProperty("totalAmount")
  private BigDecimal totalAmount = null;

  @JsonProperty("totalTex")
  private BigDecimal totalTex = null;

  @JsonProperty("totalPriceWithTax")
  private BigDecimal totalPriceWithTax = null;

  @JsonProperty("totalInvoices")
  private Long totalInvoices = null;

  @JsonProperty("totalRedInvoices")
  private Long totalRedInvoices = null;

  @JsonProperty("totalBlueInvoices")
  private Long totalBlueInvoices = null;

  @JsonProperty("attachmentURL")
  private String attachmentURL = null;

  @JsonIgnore
  public InvoiceBatchNoInfo batchNo(String outBatchNo) {
    this.outBatchNo = outBatchNo;
    return this;
  }
  /**
   * 发票批次号
   * @return outBatchNo
   **/
  @ApiModelProperty(value = "发票批次号")
  public String getOutBatchNo() {
    return outBatchNo;
  }

  public void setOutBatchNo(String outBatchNo) {
    this.outBatchNo = outBatchNo;
  }
  /**
   * 总金额
   * @return totalAmount
   **/
  @ApiModelProperty(value = "总金额")
  public BigDecimal getTotalAmount() {
    return totalAmount;
  }

  public void setTotalAmount(BigDecimal totalAmount) {
    this.totalAmount = totalAmount;
  }
  /**
   * 总税额
   * @return totalTex
   **/
  @ApiModelProperty(value = "总税额")
  public BigDecimal getTotalTex() {
    return totalTex;
  }

  public void setTotalTex(BigDecimal totalTex) {
    this.totalTex = totalTex;
  }
  /**
   * 总价税合计额
   * @return totalPriceWithTax
   **/
  @ApiModelProperty(value = "总价税合计额")
  public BigDecimal getTotalPriceWithTax() {
    return totalPriceWithTax;
  }

  public void setTotalPriceWithTax(BigDecimal totalPriceWithTax) {
    this.totalPriceWithTax = totalPriceWithTax;
  }
  /**
   * 发票总数
   * @return totalInvoices
   **/
  @ApiModelProperty(value = "发票总数")
  public Long getTotalInvoices() {
    return totalInvoices;
  }

  public void setTotalInvoices(Long totalInvoices) {
    this.totalInvoices = totalInvoices;
  }
  /**
   * 红票总数
   * @return totalRedInvoices
   **/
  @ApiModelProperty(value = "红票总数")
  public Long getTotalRedInvoices() {
    return totalRedInvoices;
  }

  public void setTotalRedInvoices(Long totalRedInvoices) {
    this.totalRedInvoices = totalRedInvoices;
  }
  /**
   * 蓝票总数
   * @return totalBlueInvoices
   **/
  @ApiModelProperty(value = "蓝票总数")
  public Long getTotalBlueInvoices() {
    return totalBlueInvoices;
  }

  public void setTotalBlueInvoices(Long totalBlueInvoices) {
    this.totalBlueInvoices = totalBlueInvoices;
  }
  /**
   * 附件URL
   * @return attachmentURL
   **/
  @ApiModelProperty(value = "附件URL")
  public String getAttachmentURL() {
    return attachmentURL;
  }

  public void setAttachmentURL(String attachmentURL) {
    this.attachmentURL = attachmentURL;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceBatchNoInfo invoiceNoCode = (InvoiceBatchNoInfo) o;
    return Objects.equals(this.outBatchNo, invoiceNoCode.outBatchNo) &&
        Objects.equals(this.totalAmount, invoiceNoCode.totalAmount) &&
        Objects.equals(this.totalTex, invoiceNoCode.totalTex) &&
            Objects.equals(this.totalPriceWithTax, invoiceNoCode.totalPriceWithTax) &&
            Objects.equals(this.totalInvoices, invoiceNoCode.totalInvoices) &&
            Objects.equals(this.totalRedInvoices, invoiceNoCode.totalRedInvoices) &&
            Objects.equals(this.totalBlueInvoices, invoiceNoCode.totalBlueInvoices) &&
            Objects.equals(this.attachmentURL, invoiceNoCode.attachmentURL);
  }

  @Override
  public int hashCode() {
    return Objects.hash(outBatchNo, totalAmount, totalTex, totalPriceWithTax, totalInvoices, totalRedInvoices, totalBlueInvoices, attachmentURL);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceBatchNoInfo {\n");

    sb.append("    outBatchNo: ").append(toIndentedString(outBatchNo)).append("\n");
    sb.append("    totalAmount: ").append(toIndentedString(totalAmount)).append("\n");
    sb.append("    totalTex: ").append(toIndentedString(totalTex)).append("\n");
    sb.append("    totalPriceWithTax: ").append(toIndentedString(totalPriceWithTax)).append("\n");
    sb.append("    totalInvoices: ").append(toIndentedString(totalInvoices)).append("\n");
    sb.append("    totalRedInvoices: ").append(toIndentedString(totalRedInvoices)).append("\n");
    sb.append("    totalBlueInvoices: ").append(toIndentedString(totalBlueInvoices)).append("\n");
    sb.append("    attachmentURL: ").append(toIndentedString(attachmentURL)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
