package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/4/25 18:29
 */
@ApiModel(description = "业务系统发票操作响应")

@JsonInclude(NON_NULL)
public class InvoiceOperationResponse {

    @JsonProperty("invoiceCode")
    @ApiModelProperty(value = "发票代码")
    private String invoiceCode;

    @JsonProperty("invoiceNo")
    @ApiModelProperty(value = "发票号码")
    private String invoiceNo;

    @JsonProperty("message")
    @ApiModelProperty(value = "处理消息")
    private String message;

    @JsonProperty("code")
    @ApiModelProperty(value = "处理结果")
    private Integer code;

    public static InvoiceOperationResponse fail(String invoiceCode, String invoiceNo, String message){
        InvoiceOperationResponse resp = new InvoiceOperationResponse();
        resp.setCode(Response.Fail);
        resp.setInvoiceCode(invoiceCode);
        resp.setInvoiceNo(invoiceNo);
        resp.setMessage(message);
        return resp;
    }

    public static InvoiceOperationResponse ok(String invoiceCode, String invoiceNo, String message){
        InvoiceOperationResponse resp = new InvoiceOperationResponse();
        resp.setCode(Response.OK);
        resp.setInvoiceCode(invoiceCode);
        resp.setInvoiceNo(invoiceNo);
        resp.setMessage(message);
        return resp;
    }

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}
