package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@ApiModel("发票红冲作废重试请求")
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class InvoiceReverseRetryRequest {
  @ApiModelProperty(value = "可红冲作废的发票id列表")
  private List<Long> invoiceIdList;
  @ApiModelProperty(value = "红冲TerminalUn")
  private String reverseTerminalUn;
  @ApiModelProperty(value = "红冲DeviceUn")
  private String reverseDeviceUn;
  @ApiModelProperty(value = "红冲TerminalType")
  private String reverseTerminalType;
  @ApiModelProperty(value = "红冲DeployType")
  private Integer reverseDeployType;
  @ApiModelProperty(value = "在线开票人")
  private String reverseIssuer;
  @ApiModelProperty("默认不传-仅批量红冲 red_issue_print-红冲并打印 ")
  private String mode = null;
  
}
