package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@JsonInclude(NON_NULL)
public class InvoiceStateResult {
	/**
	 * 发票类型
	 */
	@JsonProperty("invoiceType")
	private String invoiceType;

	/**
	 * 发票号码
	 */
	@JsonProperty("invoiceNo")
	private String invoiceNo;

	/**
	 * 发票代码
	 */
	@JsonProperty("invoiceCode")
	private String invoiceCode;

	/**
	 * 认证状态 1-已转出 2-已认证 0-未认证
	 */
	@JsonProperty("identifyStatus")
	private String identifyStatus;

	/**
	 * 付款状态 0-未付款 1-部分付款 2-已付款
	 */
	@JsonProperty("paymentStatus")
	private String paymentStatus;

	/**
	 * 退票状态 1-已退 2-撤销退票 0-未退
	 */
	@JsonProperty("retreatStatus")
	private String retreatStatus;

	public String getInvoiceType() {
		return invoiceType;
	}

	public void setInvoiceType(String invoiceType) {
		this.invoiceType = invoiceType;
	}

	public String getInvoiceNo() {
		return invoiceNo;
	}

	public void setInvoiceNo(String invoiceNo) {
		this.invoiceNo = invoiceNo;
	}

	public String getInvoiceCode() {
		return invoiceCode;
	}

	public void setInvoiceCode(String invoiceCode) {
		this.invoiceCode = invoiceCode;
	}

	/**
	 * 认证状态 1-已转出 2-已认证 0-未认证
	 */
	public String getIdentifyStatus() {
		return identifyStatus;
	}

	public void setIdentifyStatus(String identifyStatus) {
		this.identifyStatus = identifyStatus;
	}

	/**
	 * 付款状态 0-未付款 1-部分付款 2-已付款
	 */
	public String getPaymentStatus() {
		return paymentStatus;
	}

	public void setPaymentStatus(String paymentStatus) {
		this.paymentStatus = paymentStatus;
	}

	/**
	 * 退票状态 1-已退 2-撤销退票 0-未退
	 */
	public String getRetreatStatus() {
		return retreatStatus;
	}

	public void setRetreatStatus(String retreatStatus) {
		this.retreatStatus = retreatStatus;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		InvoiceStateResult obj = (InvoiceStateResult) o;
		return Objects.equals(this.invoiceNo, obj.invoiceNo) && Objects.equals(this.invoiceCode, obj.invoiceCode)
				&& Objects.equals(this.identifyStatus, obj.identifyStatus)
				&& Objects.equals(this.paymentStatus, obj.paymentStatus)
				&& Objects.equals(this.retreatStatus, obj.retreatStatus)
				&& Objects.equals(this.invoiceType, obj.invoiceType);
	}

	@Override
	public int hashCode() {
		return Objects.hash(invoiceCode, invoiceNo, identifyStatus, paymentStatus, retreatStatus, invoiceType);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("class MsInvoiceStatusUpdateRequest {\n");
		sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
		sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
		sb.append("    identifyStatus: ").append(toIndentedString(identifyStatus)).append("\n");
		sb.append("    paymentStatus: ").append(toIndentedString(paymentStatus)).append("\n");
		sb.append("    retreatStatus: ").append(toIndentedString(retreatStatus)).append("\n");
		sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
		sb.append("}");
		return sb.toString();
	}

	/**
	 * Convert the given object to string with each line indented by 4 spaces
	 * (except the first line).
	 */
	private String toIndentedString(Object o) {
		if (o == null) {
			return "null";
		}
		return o.toString().replace("\n", "\n    ");
	}
}
