package com.xforceplus.seller.invoice.client.model;

import java.util.stream.Stream;

/**
 * 开票、申请红字信息操作日志枚举定义
 */
public enum IssueEventLogEnum {

    ISSUE_DATA_CHECK_FAIL("issueDataCheckFail","开票数据校验失败事件"),

    /**
     * 发送开票数据到税件成功
     */
    ISSUE_INVOKE_TAX_WARE_SUCCESS("issueInvokeTaxWareSuccess","成功发送开票数据到税件"),

    /**
     * 发送开票数据到税件失败
     */
    ISSUE_INVOKE_TAX_WARE_FAIL("issueInvokeTaxWareFail","发送开票数据到税件失败"),

    /**
     * 开具响应结果成功
     */
    ISSUE_INVOKE_TAX_WARE_RESP_SUCCESS("issueInvokeTaxWareRespSuccess","开具响应结果成功"),

    /**
     * 开具响应失败
     */
    ISSUE_INVOKE_TAX_WARE_RESP_FAIL("issueInvokeTaxWareRespFail","开具响应失败"),

    /**
     * 申请红字信息请求失败
     */
    APPLY_RED_INFO_INVOKE_FAIL("applyRedInfoInvokeFail","申请红字信息请求失败"),

    /**
     * 申请红字信息成功
     */
    APPLY_RED_INFO_INVOKE_RESP_SUCCESS("applyRedInfoInvokeRespSuccess","申请红字信息成功"),

    /**
     * 税件申请红字信息失败
     */
    APPLY_RED_INFO_INVOKE_RESP_FAIL("applyRedInfoInvokeRespFail","税件申请红字信息失败"),

    /**
     * 作废发票请求失败
     */
    INVALID_INVOICE_REQ_FAIL("invalidInvoiceReqFail","作废发票请求失败"),

    /**
     * 作废发票响应失败
     */
    INVOICE_INVALID_RESP_FAIL("invalidInvoiceRespFail","作废发票响应失败"),

    /**
     * 作废发票响应成功
     */
    INVOICE_INVALID_RESP_SUCCESS("invalidInvoiceRespSuccess","作废发票响应成功");


    private final String code;

    private final String description;

    IssueEventLogEnum(String code, String desc)
    {
        this.code = code;
        this.description = desc;
    }

    public String value()
    {
        return  this.code;
    }

    public String description(){return this.description;}

    public static String getIssueEventLogBy(String value) {
        return Stream.of(IssueEventLogEnum.values())
                .filter(r -> r.value().equals(value))
                .map(IssueEventLogEnum::description)
                .findFirst().orElse(null);
    }

    public static IssueEventLogEnum from(String value){
       return Stream.of(IssueEventLogEnum.values())
               .filter(r -> r.value().equals(value))
               .findFirst().orElse(null);
    }
}
