package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

@ApiModel("预制发票开票请求")
@Data
public class IssuePreInvoiceRequest {

    @ApiModelProperty("是否全选")
    @NotNull
    private Integer isAllSelect;

    @ApiModelProperty("包含的预制发票id集合")
    private List<Long> includes = new ArrayList<Long>();

    @ApiModelProperty(value = "排除的预制发票id集合")
    private List<Long> excludes;

    @ApiModelProperty("查询条件")
    private ConditionRequest condition = null;

    @ApiModelProperty("搜索查询范围")
    private List<Long> createTime;

    @ApiModelProperty("终端唯一码")
    private String terminalUn;

    @ApiModelProperty("设备唯一码")
    private String deviceUn;

    @ApiModelProperty("开具方式 issue开具 issue_print开具并打印")
    private String mode;

    @ApiModelProperty("下一张发票号码")
    private String nextInvoiceNo;

    @ApiModelProperty("下一张发票代码")
    private String nextInvoiceCode;
}
