package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.ToString;
import java.math.BigDecimal;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel(description = "发票预申请红字金额信息")
@JsonInclude(NON_NULL)
@Data
@ToString
public class ItemPreReverseRecord {
  @JsonProperty("id")
  private Long id = null;
  @JsonProperty("itemId")
  private Long itemId = null;
  @JsonProperty("invoiceId")
  private Long invoiceId = null;
  @JsonProperty("rowNum")
  private Integer rowNum = null;
  @JsonProperty("preQuantity")
  private BigDecimal preQuantity = null;
  @JsonProperty("preAmountWithTax")
  private BigDecimal preAmountWithTax = null;
  @JsonProperty("preAmountWithoutTax")
  private BigDecimal preAmountWithoutTax = null;
  @JsonProperty("preTaxAmount")
  private BigDecimal preTaxAmount = null;
}
