package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 开具状态信息
 */
@ApiModel(description = "开具状态信息")

@JsonInclude(NON_NULL)
public class MakeOutStatusInfo {

    public static final String ALL_FAIL = "0";
    public static final String ALL_SUCCESS = "1";
    public static final String PART_SUCCESS = "2";

    @JsonProperty("batchStatus")
    private String batchStatus = null;

    @JsonProperty("successMakeOutIds")
    private List<Long> successMakeOutIds = new ArrayList<Long>();

    @JsonProperty("failMakeOutIds")
    private List<Long> failMakeOutIds = new ArrayList<Long>();

    @ApiModelProperty("打印发票信息")
    private List<PrintInvoiceInfo> printInvoiceInfoList;

    @ApiModelProperty("发票开具失败原因")
    private List<FailMakeOutReasonInfo> failMakeOutReason;

    @JsonIgnore
    public MakeOutStatusInfo batchStatus(String batchStatus) {
        this.batchStatus = batchStatus;
        return this;
    }

    /**
     * 批次开具状态,0=全部失败,1=全部成功,2=部分成功
     *
     * @return batchStatus
     **/
    @ApiModelProperty(value = "批次开具状态,0=全部失败,1=全部成功,2=部分成功")
    public String getBatchStatus() {
        return batchStatus;
    }

    public void setBatchStatus(String batchStatus) {
        this.batchStatus = batchStatus;
    }

    @JsonIgnore
    public MakeOutStatusInfo successMakeOutIds(List<Long> successMakeOutIds) {
        this.successMakeOutIds = successMakeOutIds;
        return this;
    }

    public MakeOutStatusInfo addSuccessMakeOutIdsItem(Long successMakeOutIdsItem) {
        this.successMakeOutIds.add(successMakeOutIdsItem);
        return this;
    }

    /**
     * 开具成功的预制发票id
     *
     * @return successMakeOutIds
     **/
    @ApiModelProperty(value = "开具成功的预制发票id")
    public List<Long> getSuccessMakeOutIds() {
        return successMakeOutIds;
    }

    public void setSuccessMakeOutIds(List<Long> successMakeOutIds) {
        this.successMakeOutIds = successMakeOutIds;
    }

    @JsonIgnore
    public MakeOutStatusInfo failMakeOutIds(List<Long> failMakeOutIds) {
        this.failMakeOutIds = failMakeOutIds;
        return this;
    }

    public MakeOutStatusInfo addFailMakeOutIdsItem(Long failMakeOutIdsItem) {
        this.failMakeOutIds.add(failMakeOutIdsItem);
        return this;
    }

    /**
     * 开具失败的预制发票id
     *
     * @return failMakeOutIds
     **/
    @ApiModelProperty(value = "开具失败的预制发票id")
    public List<Long> getFailMakeOutIds() {
        return failMakeOutIds;
    }

    public void setFailMakeOutIds(List<Long> failMakeOutIds) {
        this.failMakeOutIds = failMakeOutIds;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MakeOutStatusInfo makeOutStatusInfo = (MakeOutStatusInfo) o;
        return Objects.equals(this.batchStatus, makeOutStatusInfo.batchStatus) &&
                Objects.equals(this.successMakeOutIds, makeOutStatusInfo.successMakeOutIds) &&
                Objects.equals(this.failMakeOutIds, makeOutStatusInfo.failMakeOutIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(batchStatus, successMakeOutIds, failMakeOutIds);
    }


    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public List<PrintInvoiceInfo> getPrintInvoiceInfoList() {
        return printInvoiceInfoList;
    }

    public void setPrintInvoiceInfoList(List<PrintInvoiceInfo> printInvoiceInfoList) {
        this.printInvoiceInfoList = printInvoiceInfoList;
    }
    public List<FailMakeOutReasonInfo> getFailMakeOutReason() {
        return failMakeOutReason;
    }

    public void setFailMakeOutReason(List<FailMakeOutReasonInfo> failMakeOutReason) {
        this.failMakeOutReason = failMakeOutReason;
    }

    @Override
    public String toString() {
        return "MakeOutStatusInfo{" +
                "batchStatus='" + batchStatus + '\'' +
                ", successMakeOutIds=" + successMakeOutIds +
                ", failMakeOutIds=" + failMakeOutIds +
                ", printInvoiceInfoList=" + printInvoiceInfoList +
                ", failMakeOutReason=" + failMakeOutReason +
                '}';
    }
}
