package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetRedNoTerminalRequest {
  @JsonProperty("businessTaxNo")
  private String businessTaxNo = null;

  @JsonProperty("businessName")
  private String businessName = null;

  @JsonIgnore
  public MsGetRedNoTerminalRequest businessTaxNo(String businessTaxNo) {
    this.businessTaxNo = businessTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return businessTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getBusinessTaxNo() {
    return businessTaxNo;
  }

  public void setBusinessTaxNo(String businessTaxNo) {
    this.businessTaxNo = businessTaxNo;
  }

  @JsonIgnore
  public MsGetRedNoTerminalRequest businessName(String businessName) {
    this.businessName = businessName;
    return this;
  }

   /**
   * 公司名称
   * @return businessName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getBusinessName() {
    return businessName;
  }

  public void setBusinessName(String businessName) {
    this.businessName = businessName;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRedNoTerminalRequest getRedNoTerminalRequest = (MsGetRedNoTerminalRequest) o;
    return Objects.equals(this.businessTaxNo, getRedNoTerminalRequest.businessTaxNo) &&
        Objects.equals(this.businessName, getRedNoTerminalRequest.businessName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessTaxNo, businessName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRedNoTerminalRequest {\n");

    sb.append("    businessTaxNo: ").append(toIndentedString(businessTaxNo)).append("\n");
    sb.append("    businessName: ").append(toIndentedString(businessName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
