package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * Make out parameter.
 * 
 * @author YY
 *
 */
@JsonInclude(NON_NULL)
public class MsSplitAndMakeOutParams {

    /* fields -------------------------------------------------------------- */

    @JsonProperty("mode")
    private String mode;
    @JsonProperty("terminalId")
    private String terminalId;
    @JsonProperty("deviceId")
    private String deviceId;
    @JsonProperty("nextInvoiceNo")
    private String nextInvoiceNo;
    @JsonProperty("nextInvoiceCode")
    private String nextInvoiceCode;
    @JsonProperty("ruleId")
    private Long ruleId;
    @JsonProperty("remark")
    private String remark;
    @JsonProperty("batchNo")
    private Long batchNo;
    @JsonProperty("purchaserAddress")
    private String purchaserAddress;
    @JsonProperty("purchaserBankAccount")
    private String purchaserBankAccount;
    @JsonProperty("purchaserBankName")
    private String purchaserBankName;
    @JsonProperty("purchaserName")
    private String purchaserName;
    @JsonProperty("purchaserTaxNo")
    private String purchaserTaxNo;
    @JsonProperty("purchaserTel")
    private String purchaserTel;
    @JsonProperty("serialNo")
    private Long serialNo;

    @JsonProperty("mergeType")
    @ApiModelProperty("合并类型 0-无合并 1-组合 2-自动合并")
    private int mergeType = 0;

    /* getters/setters ----------------------------------------------------- */

    @ApiModelProperty("开票方式 1预开票 不实际开票，返回待开的发票信息集合 2仅开具 开票，但是不会打印发票 3开具并打印开票，并且打印，中间需要一次接口进行确认操作 4客户端确认开具并打印开具并打印，但是是在开票助手端确认的 5直接根据发票号码开具打印")
    public String getMode() {
        return mode;
    }

    public Long getSerialNo() {
        return serialNo;
    }

    public void setSerialNo(Long serialNo) {
        this.serialNo = serialNo;
    }

    @ApiModelProperty("设备id")
    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    @ApiModelProperty("补充备注")
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @ApiModelProperty("批次号")
    public Long getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(Long batchNo) {
        this.batchNo = batchNo;
    }

    @ApiModelProperty("购方地址")
    public String getPurchaserAddress() {
        return purchaserAddress;
    }

    public void setPurchaserAddress(String purchaserAddress) {
        this.purchaserAddress = purchaserAddress;
    }

    @ApiModelProperty("购方银行账号")
    public String getPurchaserBankAccount() {
        return purchaserBankAccount;
    }

    public void setPurchaserBankAccount(String purchaserBankAccount) {
        this.purchaserBankAccount = purchaserBankAccount;
    }

    @ApiModelProperty("购方银行名称")
    public String getPurchaserBankName() {
        return purchaserBankName;
    }

    public void setPurchaserBankName(String purchaserBankName) {
        this.purchaserBankName = purchaserBankName;
    }

    @ApiModelProperty("购方名称")
    public String getPurchaserName() {
        return purchaserName;
    }

    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
    }

    @ApiModelProperty("购方税号")
    public String getPurchaserTaxNo() {
        return purchaserTaxNo;
    }

    public void setPurchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
    }

    @ApiModelProperty("购方电话")
    public String getPurchaserTel() {
        return purchaserTel;
    }

    public void setPurchaserTel(String purchaserTel) {
        this.purchaserTel = purchaserTel;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    @ApiModelProperty("终端Id")
    public String getTerminalId() {
        return terminalId;
    }

    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    @ApiModelProperty("下一张发票号码")
    public String getNextInvoiceNo() {
        return nextInvoiceNo;
    }

    public void setNextInvoiceNo(String nextInvoiceNo) {
        this.nextInvoiceNo = nextInvoiceNo;
    }

    @ApiModelProperty("下一张发票代码")
    public String getNextInvoiceCode() {
        return nextInvoiceCode;
    }

    public void setNextInvoiceCode(String nextInvoiceCode) {
        this.nextInvoiceCode = nextInvoiceCode;
    }

    @ApiModelProperty("开票规则Id")
    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    public int getMergeType() {
        return mergeType;
    }

    public void setMergeType(int mergeType) {
        this.mergeType = mergeType;
    }
}
