package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.xforceplus.xplatframework.apimodel.PollingModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 打印销货清单轮询结果对象
 */
@ApiModel(description = "打印销货清单轮询结果对象")
@JsonInclude(NON_NULL)
@Data
public class PollingPrintSellListResult extends PollingModel {
    @ApiModelProperty(value = "打印销货清单失败总数")
    private int failedCount = 0;
    @ApiModelProperty(value = "打印销货清单成功总数")
    private int successCount = 0;
    @ApiModelProperty(value = "发票打印总数")
    private int printTotal = 0;
    @ApiModelProperty(value = "是否单张返回")
    private Boolean singleReturn = false;
}
