package com.xforceplus.seller.invoice.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * PreInvoiceUpdatesResponse
 */

@JsonInclude(NON_NULL)
public class PreInvoiceUpdatesResponse {
    @JsonProperty("code")
    private String code = "1";

    @JsonProperty("message")
    private String message = "获取成功!";

    @JsonProperty("result")
    private PreInvoiceUpdateResult result = null;

    @JsonIgnore
    public PreInvoiceUpdatesResponse code(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get code
     *
     * @return code
     **/
    @ApiModelProperty(value = "")
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @JsonIgnore
    public PreInvoiceUpdatesResponse message(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get message
     *
     * @return message
     **/
    @ApiModelProperty(value = "")
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    public PreInvoiceUpdatesResponse result(PreInvoiceUpdateResult result) {
        this.result = result;
        return this;
    }

    /**
     * Get result
     *
     * @return result
     **/
    @ApiModelProperty(value = "")
    public PreInvoiceUpdateResult getResult() {
        return result;
    }

    public void setResult(PreInvoiceUpdateResult result) {
        this.result = result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PreInvoiceUpdatesResponse pollingRedFlushInvoiceResultResponse = (PreInvoiceUpdatesResponse) o;
        return Objects.equals(this.code, pollingRedFlushInvoiceResultResponse.code)
                && Objects.equals(this.message, pollingRedFlushInvoiceResultResponse.message)
                && Objects.equals(this.result, pollingRedFlushInvoiceResultResponse.result);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, message, result);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PreInvoiceUpdatesResponse {\n");

        sb.append("    code: ").append(toIndentedString(code)).append("\n");
        sb.append("    message: ").append(toIndentedString(message)).append("\n");
        sb.append("    result: ").append(toIndentedString(result)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
