package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@JsonInclude(NON_NULL)
public class QueryInvoicesBySaleIResult {

    @JsonProperty("invoices")
    private List<QuerySellerInvoice> invoices;
    @JsonProperty("totalNum")
    public Long totalNum;

    @ApiModelProperty(value = "发票列表")
    public List<QuerySellerInvoice> getInvoices() {
        return invoices;
    }

    public void setInvoices(List<QuerySellerInvoice> invoices) {
        this.invoices = invoices;
    }

    @ApiModelProperty(value = "总条数")
    public Long getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Long totalNum) {
        this.totalNum = totalNum;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        QueryInvoicesBySaleIResult that = (QueryInvoicesBySaleIResult) o;
        return Objects.equals(invoices, that.invoices);
    }

    @Override
    public int hashCode() {

        return Objects.hash(invoices);
    }

    @Override
    public String toString() {
        return "QueryInvoicesBySaleIResult{" +
                "invoices=" + invoices +
                '}';
    }
}
