package com.xforceplus.seller.invoice.client.model;

import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/8/25 18:08
 */
@Getter
@Setter
public class QueryMakeOutFailResponse extends BaseResponse {

    @ApiModelProperty(value = "总数")
    private long total;

    @ApiModelProperty(value = "失败列表")
    private List<MakeOutFailInfo> result;

    public QueryMakeOutFailResponse ok(List<MakeOutFailInfo> result, long total, String message){
        this.setCode(Response.OK);
        this.total = total;
        this.setMessage(message);
        this.result = result;
        return this;
    }

    public QueryMakeOutFailResponse fail(String message){
        this.setCode(Response.Fail);
        this.setMessage(message);
        return this;
    }
}
